package io.kubernetes.client.openapi.models;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1PersistentVolumeClaimConditionFluentImpl<A extends V1PersistentVolumeClaimConditionFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PersistentVolumeClaimConditionFluent<A>{

    private DateTime lastProbeTime;
    private DateTime lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public V1PersistentVolumeClaimConditionFluentImpl(){
    }
    public V1PersistentVolumeClaimConditionFluentImpl(V1PersistentVolumeClaimCondition instance){
            this.withLastProbeTime(instance.getLastProbeTime());

            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

    }

    public DateTime getLastProbeTime(){
            return this.lastProbeTime;
    }

    public A withLastProbeTime(DateTime lastProbeTime){
            this.lastProbeTime=lastProbeTime; return (A) this;
    }

    public Boolean hasLastProbeTime(){
            return this.lastProbeTime != null;
    }

    public A withNewLastProbeTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastProbeTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastProbeTime(Object arg0){
            return (A)withLastProbeTime(new DateTime(arg0));
    }

    public A withNewLastProbeTime(long arg0){
            return (A)withLastProbeTime(new DateTime(arg0));
    }

    public DateTime getLastTransitionTime(){
            return this.lastTransitionTime;
    }

    public A withLastTransitionTime(DateTime lastTransitionTime){
            this.lastTransitionTime=lastTransitionTime; return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime != null;
    }

    public A withNewLastTransitionTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastTransitionTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastTransitionTime(Object arg0){
            return (A)withLastTransitionTime(new DateTime(arg0));
    }

    public A withNewLastTransitionTime(long arg0){
            return (A)withLastTransitionTime(new DateTime(arg0));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public A withNewMessage(String arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuilder arg1){
            return (A)withMessage(new String(arg1));
    }

    public A withNewMessage(StringBuffer arg1){
            return (A)withMessage(new String(arg1));
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public A withNewReason(String arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1){
            return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1){
            return (A)withReason(new String(arg1));
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public A withNewStatus(String arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuilder arg1){
            return (A)withStatus(new String(arg1));
    }

    public A withNewStatus(StringBuffer arg1){
            return (A)withStatus(new String(arg1));
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public A withNewType(String arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuilder arg1){
            return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1){
            return (A)withType(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1PersistentVolumeClaimConditionFluentImpl that = (V1PersistentVolumeClaimConditionFluentImpl) o;
            if (lastProbeTime != null ? !lastProbeTime.equals(that.lastProbeTime) :that.lastProbeTime != null) return false;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
