package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NodeSelectorBuilder extends V1NodeSelectorFluentImpl<V1NodeSelectorBuilder> implements VisitableBuilder<V1NodeSelector,V1NodeSelectorBuilder>{

    V1NodeSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1NodeSelectorBuilder(){
            this(true);
    }
    public V1NodeSelectorBuilder(Boolean validationEnabled){
            this(new V1NodeSelector(), validationEnabled);
    }
    public V1NodeSelectorBuilder(V1NodeSelectorFluent<?> fluent){
            this(fluent, true);
    }
    public V1NodeSelectorBuilder(V1NodeSelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NodeSelector(), validationEnabled);
    }
    public V1NodeSelectorBuilder(V1NodeSelectorFluent<?> fluent,V1NodeSelector instance){
            this(fluent, instance, true);
    }
    public V1NodeSelectorBuilder(V1NodeSelectorFluent<?> fluent,V1NodeSelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNodeSelectorTerms(instance.getNodeSelectorTerms());

            this.validationEnabled = validationEnabled; 
    }
    public V1NodeSelectorBuilder(V1NodeSelector instance){
            this(instance,true);
    }
    public V1NodeSelectorBuilder(V1NodeSelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNodeSelectorTerms(instance.getNodeSelectorTerms());

            this.validationEnabled = validationEnabled; 
    }

    public V1NodeSelector build(){
            V1NodeSelector buildable = new V1NodeSelector();
            buildable.setNodeSelectorTerms(fluent.getNodeSelectorTerms());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NodeSelectorBuilder that = (V1NodeSelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
