package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1NetworkPolicySpecBuilder extends V1NetworkPolicySpecFluentImpl<V1NetworkPolicySpecBuilder> implements VisitableBuilder<V1NetworkPolicySpec,V1NetworkPolicySpecBuilder>{

    V1NetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1NetworkPolicySpecBuilder(){
            this(true);
    }
    public V1NetworkPolicySpecBuilder(Boolean validationEnabled){
            this(new V1NetworkPolicySpec(), validationEnabled);
    }
    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1NetworkPolicySpec(), validationEnabled);
    }
    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent,V1NetworkPolicySpec instance){
            this(fluent, instance, true);
    }
    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpecFluent<?> fluent,V1NetworkPolicySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEgress(instance.getEgress());

            fluent.withIngress(instance.getIngress());

            fluent.withPodSelector(instance.getPodSelector());

            fluent.withPolicyTypes(instance.getPolicyTypes());

            this.validationEnabled = validationEnabled; 
    }
    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpec instance){
            this(instance,true);
    }
    public V1NetworkPolicySpecBuilder(V1NetworkPolicySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEgress(instance.getEgress());

            this.withIngress(instance.getIngress());

            this.withPodSelector(instance.getPodSelector());

            this.withPolicyTypes(instance.getPolicyTypes());

            this.validationEnabled = validationEnabled; 
    }

    public V1NetworkPolicySpec build(){
            V1NetworkPolicySpec buildable = new V1NetworkPolicySpec();
            buildable.setEgress(fluent.getEgress());
            buildable.setIngress(fluent.getIngress());
            buildable.setPodSelector(fluent.getPodSelector());
            buildable.setPolicyTypes(fluent.getPolicyTypes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NetworkPolicySpecBuilder that = (V1NetworkPolicySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
