package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1MutatingWebhookConfigurationBuilder extends V1MutatingWebhookConfigurationFluentImpl<V1MutatingWebhookConfigurationBuilder> implements VisitableBuilder<V1MutatingWebhookConfiguration,V1MutatingWebhookConfigurationBuilder>{

    V1MutatingWebhookConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public V1MutatingWebhookConfigurationBuilder(){
            this(true);
    }
    public V1MutatingWebhookConfigurationBuilder(Boolean validationEnabled){
            this(new V1MutatingWebhookConfiguration(), validationEnabled);
    }
    public V1MutatingWebhookConfigurationBuilder(V1MutatingWebhookConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public V1MutatingWebhookConfigurationBuilder(V1MutatingWebhookConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1MutatingWebhookConfiguration(), validationEnabled);
    }
    public V1MutatingWebhookConfigurationBuilder(V1MutatingWebhookConfigurationFluent<?> fluent,V1MutatingWebhookConfiguration instance){
            this(fluent, instance, true);
    }
    public V1MutatingWebhookConfigurationBuilder(V1MutatingWebhookConfigurationFluent<?> fluent,V1MutatingWebhookConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withWebhooks(instance.getWebhooks());

            this.validationEnabled = validationEnabled; 
    }
    public V1MutatingWebhookConfigurationBuilder(V1MutatingWebhookConfiguration instance){
            this(instance,true);
    }
    public V1MutatingWebhookConfigurationBuilder(V1MutatingWebhookConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withWebhooks(instance.getWebhooks());

            this.validationEnabled = validationEnabled; 
    }

    public V1MutatingWebhookConfiguration build(){
            V1MutatingWebhookConfiguration buildable = new V1MutatingWebhookConfiguration();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setWebhooks(fluent.getWebhooks());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1MutatingWebhookConfigurationBuilder that = (V1MutatingWebhookConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
