package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1LocalObjectReferenceBuilder extends V1LocalObjectReferenceFluentImpl<V1LocalObjectReferenceBuilder> implements VisitableBuilder<V1LocalObjectReference,V1LocalObjectReferenceBuilder>{

    V1LocalObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V1LocalObjectReferenceBuilder(){
            this(true);
    }
    public V1LocalObjectReferenceBuilder(Boolean validationEnabled){
            this(new V1LocalObjectReference(), validationEnabled);
    }
    public V1LocalObjectReferenceBuilder(V1LocalObjectReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public V1LocalObjectReferenceBuilder(V1LocalObjectReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1LocalObjectReference(), validationEnabled);
    }
    public V1LocalObjectReferenceBuilder(V1LocalObjectReferenceFluent<?> fluent,V1LocalObjectReference instance){
            this(fluent, instance, true);
    }
    public V1LocalObjectReferenceBuilder(V1LocalObjectReferenceFluent<?> fluent,V1LocalObjectReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public V1LocalObjectReferenceBuilder(V1LocalObjectReference instance){
            this(instance,true);
    }
    public V1LocalObjectReferenceBuilder(V1LocalObjectReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public V1LocalObjectReference build(){
            V1LocalObjectReference buildable = new V1LocalObjectReference();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1LocalObjectReferenceBuilder that = (V1LocalObjectReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
