package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1HostPathVolumeSourceBuilder extends V1HostPathVolumeSourceFluentImpl<V1HostPathVolumeSourceBuilder> implements VisitableBuilder<V1HostPathVolumeSource,V1HostPathVolumeSourceBuilder>{

    V1HostPathVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1HostPathVolumeSourceBuilder(){
            this(true);
    }
    public V1HostPathVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1HostPathVolumeSource(), validationEnabled);
    }
    public V1HostPathVolumeSourceBuilder(V1HostPathVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1HostPathVolumeSourceBuilder(V1HostPathVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1HostPathVolumeSource(), validationEnabled);
    }
    public V1HostPathVolumeSourceBuilder(V1HostPathVolumeSourceFluent<?> fluent,V1HostPathVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1HostPathVolumeSourceBuilder(V1HostPathVolumeSourceFluent<?> fluent,V1HostPathVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPath(instance.getPath());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V1HostPathVolumeSourceBuilder(V1HostPathVolumeSource instance){
            this(instance,true);
    }
    public V1HostPathVolumeSourceBuilder(V1HostPathVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPath(instance.getPath());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V1HostPathVolumeSource build(){
            V1HostPathVolumeSource buildable = new V1HostPathVolumeSource();
            buildable.setPath(fluent.getPath());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1HostPathVolumeSourceBuilder that = (V1HostPathVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
