package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1HorizontalPodAutoscalerSpecBuilder extends V1HorizontalPodAutoscalerSpecFluentImpl<V1HorizontalPodAutoscalerSpecBuilder> implements VisitableBuilder<V1HorizontalPodAutoscalerSpec,V1HorizontalPodAutoscalerSpecBuilder>{

    V1HorizontalPodAutoscalerSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1HorizontalPodAutoscalerSpecBuilder(){
            this(true);
    }
    public V1HorizontalPodAutoscalerSpecBuilder(Boolean validationEnabled){
            this(new V1HorizontalPodAutoscalerSpec(), validationEnabled);
    }
    public V1HorizontalPodAutoscalerSpecBuilder(V1HorizontalPodAutoscalerSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1HorizontalPodAutoscalerSpecBuilder(V1HorizontalPodAutoscalerSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1HorizontalPodAutoscalerSpec(), validationEnabled);
    }
    public V1HorizontalPodAutoscalerSpecBuilder(V1HorizontalPodAutoscalerSpecFluent<?> fluent,V1HorizontalPodAutoscalerSpec instance){
            this(fluent, instance, true);
    }
    public V1HorizontalPodAutoscalerSpecBuilder(V1HorizontalPodAutoscalerSpecFluent<?> fluent,V1HorizontalPodAutoscalerSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMaxReplicas(instance.getMaxReplicas());

            fluent.withMinReplicas(instance.getMinReplicas());

            fluent.withScaleTargetRef(instance.getScaleTargetRef());

            fluent.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());

            this.validationEnabled = validationEnabled; 
    }
    public V1HorizontalPodAutoscalerSpecBuilder(V1HorizontalPodAutoscalerSpec instance){
            this(instance,true);
    }
    public V1HorizontalPodAutoscalerSpecBuilder(V1HorizontalPodAutoscalerSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMaxReplicas(instance.getMaxReplicas());

            this.withMinReplicas(instance.getMinReplicas());

            this.withScaleTargetRef(instance.getScaleTargetRef());

            this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());

            this.validationEnabled = validationEnabled; 
    }

    public V1HorizontalPodAutoscalerSpec build(){
            V1HorizontalPodAutoscalerSpec buildable = new V1HorizontalPodAutoscalerSpec();
            buildable.setMaxReplicas(fluent.getMaxReplicas());
            buildable.setMinReplicas(fluent.getMinReplicas());
            buildable.setScaleTargetRef(fluent.getScaleTargetRef());
            buildable.setTargetCPUUtilizationPercentage(fluent.getTargetCPUUtilizationPercentage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1HorizontalPodAutoscalerSpecBuilder that = (V1HorizontalPodAutoscalerSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
