package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ConfigMapVolumeSourceBuilder extends V1ConfigMapVolumeSourceFluentImpl<V1ConfigMapVolumeSourceBuilder> implements VisitableBuilder<V1ConfigMapVolumeSource,V1ConfigMapVolumeSourceBuilder>{

    V1ConfigMapVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1ConfigMapVolumeSourceBuilder(){
            this(true);
    }
    public V1ConfigMapVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1ConfigMapVolumeSource(), validationEnabled);
    }
    public V1ConfigMapVolumeSourceBuilder(V1ConfigMapVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1ConfigMapVolumeSourceBuilder(V1ConfigMapVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ConfigMapVolumeSource(), validationEnabled);
    }
    public V1ConfigMapVolumeSourceBuilder(V1ConfigMapVolumeSourceFluent<?> fluent,V1ConfigMapVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1ConfigMapVolumeSourceBuilder(V1ConfigMapVolumeSourceFluent<?> fluent,V1ConfigMapVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withDefaultMode(instance.getDefaultMode());

            fluent.withItems(instance.getItems());

            fluent.withName(instance.getName());

            fluent.withOptional(instance.getOptional());

            this.validationEnabled = validationEnabled; 
    }
    public V1ConfigMapVolumeSourceBuilder(V1ConfigMapVolumeSource instance){
            this(instance,true);
    }
    public V1ConfigMapVolumeSourceBuilder(V1ConfigMapVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withDefaultMode(instance.getDefaultMode());

            this.withItems(instance.getItems());

            this.withName(instance.getName());

            this.withOptional(instance.getOptional());

            this.validationEnabled = validationEnabled; 
    }

    public V1ConfigMapVolumeSource build(){
            V1ConfigMapVolumeSource buildable = new V1ConfigMapVolumeSource();
            buildable.setDefaultMode(fluent.getDefaultMode());
            buildable.setItems(fluent.getItems());
            buildable.setName(fluent.getName());
            buildable.setOptional(fluent.isOptional());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ConfigMapVolumeSourceBuilder that = (V1ConfigMapVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
