package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1CinderVolumeSourceFluentImpl<A extends V1CinderVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1CinderVolumeSourceFluent<A>{

    private String fsType;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;
    private String volumeID;

    public V1CinderVolumeSourceFluentImpl(){
    }
    public V1CinderVolumeSourceFluentImpl(V1CinderVolumeSource instance){
            this.withFsType(instance.getFsType());

            this.withReadOnly(instance.getReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.withVolumeID(instance.getVolumeID());

    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public A withNewFsType(String arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuilder arg1){
            return (A)withFsType(new String(arg1));
    }

    public A withNewFsType(StringBuffer arg1){
            return (A)withFsType(new String(arg1));
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1LocalObjectReference getSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public V1LocalObjectReference buildSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(V1LocalObjectReference secretRef){
            _visitables.get("secretRef").remove(this.secretRef);
            if (secretRef!=null){ this.secretRef= new V1LocalObjectReferenceBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef(){
            return this.secretRef != null;
    }

    public V1CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRef(){
            return new SecretRefNestedImpl();
    }

    public V1CinderVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item){
            return new SecretRefNestedImpl(item);
    }

    public V1CinderVolumeSourceFluent.SecretRefNested<A> editSecretRef(){
            return withNewSecretRefLike(getSecretRef());
    }

    public V1CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef(){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new V1LocalObjectReferenceBuilder().build());
    }

    public V1CinderVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public String getVolumeID(){
            return this.volumeID;
    }

    public A withVolumeID(String volumeID){
            this.volumeID=volumeID; return (A) this;
    }

    public Boolean hasVolumeID(){
            return this.volumeID != null;
    }

    public A withNewVolumeID(String arg1){
            return (A)withVolumeID(new String(arg1));
    }

    public A withNewVolumeID(StringBuilder arg1){
            return (A)withVolumeID(new String(arg1));
    }

    public A withNewVolumeID(StringBuffer arg1){
            return (A)withVolumeID(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            V1CinderVolumeSourceFluentImpl that = (V1CinderVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
            if (volumeID != null ? !volumeID.equals(that.volumeID) :that.volumeID != null) return false;
            return true;
    }


    public class SecretRefNestedImpl<N> extends V1LocalObjectReferenceFluentImpl<V1CinderVolumeSourceFluent.SecretRefNested<N>> implements V1CinderVolumeSourceFluent.SecretRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LocalObjectReferenceBuilder builder;
    
            SecretRefNestedImpl(V1LocalObjectReference item){
                    this.builder = new V1LocalObjectReferenceBuilder(this, item);
            }
            SecretRefNestedImpl(){
                    this.builder = new V1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1CinderVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef(){
            return and();
    }

}


}
