package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1APIGroupListFluent<A extends V1APIGroupListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToGroups(int index,V1APIGroup item);
    public A setToGroups(int index,V1APIGroup item);
    public A addToGroups(V1APIGroup... items);
    public A addAllToGroups(Collection<V1APIGroup> items);
    public A removeFromGroups(V1APIGroup... items);
    public A removeAllFromGroups(Collection<V1APIGroup> items);
    public A removeMatchingFromGroups(io.kubernetes.client.fluent.Predicate<V1APIGroupBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildGroups instead.
 * @return The buildable object.
 */
@Deprecated public List<V1APIGroup> getGroups();
    public List<V1APIGroup> buildGroups();
    public V1APIGroup buildGroup(int index);
    public V1APIGroup buildFirstGroup();
    public V1APIGroup buildLastGroup();
    public V1APIGroup buildMatchingGroup(io.kubernetes.client.fluent.Predicate<V1APIGroupBuilder> predicate);
    public Boolean hasMatchingGroup(io.kubernetes.client.fluent.Predicate<V1APIGroupBuilder> predicate);
    public A withGroups(List<V1APIGroup> groups);
    public A withGroups(V1APIGroup... groups);
    public Boolean hasGroups();
    public V1APIGroupListFluent.GroupsNested<A> addNewGroup();
    public V1APIGroupListFluent.GroupsNested<A> addNewGroupLike(V1APIGroup item);
    public V1APIGroupListFluent.GroupsNested<A> setNewGroupLike(int index,V1APIGroup item);
    public V1APIGroupListFluent.GroupsNested<A> editGroup(int index);
    public V1APIGroupListFluent.GroupsNested<A> editFirstGroup();
    public V1APIGroupListFluent.GroupsNested<A> editLastGroup();
    public V1APIGroupListFluent.GroupsNested<A> editMatchingGroup(io.kubernetes.client.fluent.Predicate<V1APIGroupBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);

    public interface GroupsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1APIGroupFluent<V1APIGroupListFluent.GroupsNested<N>>{

        
    public N and();    public N endGroup();
}


}
