package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder extends PolicyV1beta1SupplementalGroupsStrategyOptionsFluentImpl<PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder> implements VisitableBuilder<PolicyV1beta1SupplementalGroupsStrategyOptions,PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder>{

    PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(){
            this(true);
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1SupplementalGroupsStrategyOptions(), validationEnabled);
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1SupplementalGroupsStrategyOptions(), validationEnabled);
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent,PolicyV1beta1SupplementalGroupsStrategyOptions instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(PolicyV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent,PolicyV1beta1SupplementalGroupsStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges());

            fluent.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(PolicyV1beta1SupplementalGroupsStrategyOptions instance){
            this(instance,true);
    }
    public PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder(PolicyV1beta1SupplementalGroupsStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptions build(){
            PolicyV1beta1SupplementalGroupsStrategyOptions buildable = new PolicyV1beta1SupplementalGroupsStrategyOptions();
            buildable.setRanges(fluent.getRanges());
            buildable.setRule(fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder that = (PolicyV1beta1SupplementalGroupsStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
