package io.kubernetes.client.openapi.models;

import java.lang.StringBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.StringBuffer;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PolicyV1beta1RuntimeClassStrategyOptionsFluentImpl<A extends PolicyV1beta1RuntimeClassStrategyOptionsFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements PolicyV1beta1RuntimeClassStrategyOptionsFluent<A>{

    private List<String> allowedRuntimeClassNames;
    private String defaultRuntimeClassName;

    public PolicyV1beta1RuntimeClassStrategyOptionsFluentImpl(){
    }
    public PolicyV1beta1RuntimeClassStrategyOptionsFluentImpl(PolicyV1beta1RuntimeClassStrategyOptions instance){
            this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());

            this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());

    }

    public A addToAllowedRuntimeClassNames(int index,String item){
            if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
            this.allowedRuntimeClassNames.add(index, item);
            return (A)this;
    }

    public A setToAllowedRuntimeClassNames(int index,String item){
            if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
            this.allowedRuntimeClassNames.set(index, item); return (A)this;
    }

    public A addToAllowedRuntimeClassNames(String... items){
            if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
            for (String item : items) {this.allowedRuntimeClassNames.add(item);} return (A)this;
    }

    public A addAllToAllowedRuntimeClassNames(Collection<String> items){
            if (this.allowedRuntimeClassNames == null) {this.allowedRuntimeClassNames = new ArrayList<String>();}
            for (String item : items) {this.allowedRuntimeClassNames.add(item);} return (A)this;
    }

    public A removeFromAllowedRuntimeClassNames(String... items){
            for (String item : items) {if (this.allowedRuntimeClassNames!= null){ this.allowedRuntimeClassNames.remove(item);}} return (A)this;
    }

    public A removeAllFromAllowedRuntimeClassNames(Collection<String> items){
            for (String item : items) {if (this.allowedRuntimeClassNames!= null){ this.allowedRuntimeClassNames.remove(item);}} return (A)this;
    }

    public List<String> getAllowedRuntimeClassNames(){
            return this.allowedRuntimeClassNames;
    }

    public String getAllowedRuntimeClassName(int index){
            return this.allowedRuntimeClassNames.get(index);
    }

    public String getFirstAllowedRuntimeClassName(){
            return this.allowedRuntimeClassNames.get(0);
    }

    public String getLastAllowedRuntimeClassName(){
            return this.allowedRuntimeClassNames.get(allowedRuntimeClassNames.size() - 1);
    }

    public String getMatchingAllowedRuntimeClassName(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedRuntimeClassNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAllowedRuntimeClassName(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: allowedRuntimeClassNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames){
            if (this.allowedRuntimeClassNames != null) { _visitables.get("allowedRuntimeClassNames").removeAll(this.allowedRuntimeClassNames);}
            if (allowedRuntimeClassNames != null) {this.allowedRuntimeClassNames = new ArrayList<String>(); for (String item : allowedRuntimeClassNames){this.addToAllowedRuntimeClassNames(item);}} else { this.allowedRuntimeClassNames = null;} return (A) this;
    }

    public A withAllowedRuntimeClassNames(String... allowedRuntimeClassNames){
            if (this.allowedRuntimeClassNames != null) {this.allowedRuntimeClassNames.clear();}
            if (allowedRuntimeClassNames != null) {for (String item :allowedRuntimeClassNames){ this.addToAllowedRuntimeClassNames(item);}} return (A) this;
    }

    public Boolean hasAllowedRuntimeClassNames(){
            return allowedRuntimeClassNames != null && !allowedRuntimeClassNames.isEmpty();
    }

    public A addNewAllowedRuntimeClassName(String arg1){
            return (A)addToAllowedRuntimeClassNames(new String(arg1));
    }

    public A addNewAllowedRuntimeClassName(StringBuilder arg1){
            return (A)addToAllowedRuntimeClassNames(new String(arg1));
    }

    public A addNewAllowedRuntimeClassName(StringBuffer arg1){
            return (A)addToAllowedRuntimeClassNames(new String(arg1));
    }

    public String getDefaultRuntimeClassName(){
            return this.defaultRuntimeClassName;
    }

    public A withDefaultRuntimeClassName(String defaultRuntimeClassName){
            this.defaultRuntimeClassName=defaultRuntimeClassName; return (A) this;
    }

    public Boolean hasDefaultRuntimeClassName(){
            return this.defaultRuntimeClassName != null;
    }

    public A withNewDefaultRuntimeClassName(String arg1){
            return (A)withDefaultRuntimeClassName(new String(arg1));
    }

    public A withNewDefaultRuntimeClassName(StringBuilder arg1){
            return (A)withDefaultRuntimeClassName(new String(arg1));
    }

    public A withNewDefaultRuntimeClassName(StringBuffer arg1){
            return (A)withDefaultRuntimeClassName(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PolicyV1beta1RuntimeClassStrategyOptionsFluentImpl that = (PolicyV1beta1RuntimeClassStrategyOptionsFluentImpl) o;
            if (allowedRuntimeClassNames != null ? !allowedRuntimeClassNames.equals(that.allowedRuntimeClassNames) :that.allowedRuntimeClassNames != null) return false;
            if (defaultRuntimeClassName != null ? !defaultRuntimeClassName.equals(that.defaultRuntimeClassName) :that.defaultRuntimeClassName != null) return false;
            return true;
    }




}
