package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1PodSecurityPolicySpecBuilder extends PolicyV1beta1PodSecurityPolicySpecFluentImpl<PolicyV1beta1PodSecurityPolicySpecBuilder> implements VisitableBuilder<PolicyV1beta1PodSecurityPolicySpec,PolicyV1beta1PodSecurityPolicySpecBuilder>{

    PolicyV1beta1PodSecurityPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1PodSecurityPolicySpecBuilder(){
            this(true);
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1PodSecurityPolicySpec(), validationEnabled);
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(PolicyV1beta1PodSecurityPolicySpecFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(PolicyV1beta1PodSecurityPolicySpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1PodSecurityPolicySpec(), validationEnabled);
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(PolicyV1beta1PodSecurityPolicySpecFluent<?> fluent,PolicyV1beta1PodSecurityPolicySpec instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(PolicyV1beta1PodSecurityPolicySpecFluent<?> fluent,PolicyV1beta1PodSecurityPolicySpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());

            fluent.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());

            fluent.withAllowedCapabilities(instance.getAllowedCapabilities());

            fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());

            fluent.withAllowedHostPaths(instance.getAllowedHostPaths());

            fluent.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());

            fluent.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());

            fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());

            fluent.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());

            fluent.withForbiddenSysctls(instance.getForbiddenSysctls());

            fluent.withFsGroup(instance.getFsGroup());

            fluent.withHostIPC(instance.getHostIPC());

            fluent.withHostNetwork(instance.getHostNetwork());

            fluent.withHostPID(instance.getHostPID());

            fluent.withHostPorts(instance.getHostPorts());

            fluent.withPrivileged(instance.getPrivileged());

            fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());

            fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());

            fluent.withRunAsGroup(instance.getRunAsGroup());

            fluent.withRunAsUser(instance.getRunAsUser());

            fluent.withRuntimeClass(instance.getRuntimeClass());

            fluent.withSeLinux(instance.getSeLinux());

            fluent.withSupplementalGroups(instance.getSupplementalGroups());

            fluent.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(PolicyV1beta1PodSecurityPolicySpec instance){
            this(instance,true);
    }
    public PolicyV1beta1PodSecurityPolicySpecBuilder(PolicyV1beta1PodSecurityPolicySpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());

            this.withAllowedCSIDrivers(instance.getAllowedCSIDrivers());

            this.withAllowedCapabilities(instance.getAllowedCapabilities());

            this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());

            this.withAllowedHostPaths(instance.getAllowedHostPaths());

            this.withAllowedProcMountTypes(instance.getAllowedProcMountTypes());

            this.withAllowedUnsafeSysctls(instance.getAllowedUnsafeSysctls());

            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());

            this.withDefaultAllowPrivilegeEscalation(instance.getDefaultAllowPrivilegeEscalation());

            this.withForbiddenSysctls(instance.getForbiddenSysctls());

            this.withFsGroup(instance.getFsGroup());

            this.withHostIPC(instance.getHostIPC());

            this.withHostNetwork(instance.getHostNetwork());

            this.withHostPID(instance.getHostPID());

            this.withHostPorts(instance.getHostPorts());

            this.withPrivileged(instance.getPrivileged());

            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());

            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());

            this.withRunAsGroup(instance.getRunAsGroup());

            this.withRunAsUser(instance.getRunAsUser());

            this.withRuntimeClass(instance.getRuntimeClass());

            this.withSeLinux(instance.getSeLinux());

            this.withSupplementalGroups(instance.getSupplementalGroups());

            this.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1PodSecurityPolicySpec build(){
            PolicyV1beta1PodSecurityPolicySpec buildable = new PolicyV1beta1PodSecurityPolicySpec();
            buildable.setAllowPrivilegeEscalation(fluent.isAllowPrivilegeEscalation());
            buildable.setAllowedCSIDrivers(fluent.getAllowedCSIDrivers());
            buildable.setAllowedCapabilities(fluent.getAllowedCapabilities());
            buildable.setAllowedFlexVolumes(fluent.getAllowedFlexVolumes());
            buildable.setAllowedHostPaths(fluent.getAllowedHostPaths());
            buildable.setAllowedProcMountTypes(fluent.getAllowedProcMountTypes());
            buildable.setAllowedUnsafeSysctls(fluent.getAllowedUnsafeSysctls());
            buildable.setDefaultAddCapabilities(fluent.getDefaultAddCapabilities());
            buildable.setDefaultAllowPrivilegeEscalation(fluent.isDefaultAllowPrivilegeEscalation());
            buildable.setForbiddenSysctls(fluent.getForbiddenSysctls());
            buildable.setFsGroup(fluent.getFsGroup());
            buildable.setHostIPC(fluent.isHostIPC());
            buildable.setHostNetwork(fluent.isHostNetwork());
            buildable.setHostPID(fluent.isHostPID());
            buildable.setHostPorts(fluent.getHostPorts());
            buildable.setPrivileged(fluent.isPrivileged());
            buildable.setReadOnlyRootFilesystem(fluent.isReadOnlyRootFilesystem());
            buildable.setRequiredDropCapabilities(fluent.getRequiredDropCapabilities());
            buildable.setRunAsGroup(fluent.getRunAsGroup());
            buildable.setRunAsUser(fluent.getRunAsUser());
            buildable.setRuntimeClass(fluent.getRuntimeClass());
            buildable.setSeLinux(fluent.getSeLinux());
            buildable.setSupplementalGroups(fluent.getSupplementalGroups());
            buildable.setVolumes(fluent.getVolumes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1PodSecurityPolicySpecBuilder that = (PolicyV1beta1PodSecurityPolicySpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
