package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1PodSecurityPolicyBuilder extends PolicyV1beta1PodSecurityPolicyFluentImpl<PolicyV1beta1PodSecurityPolicyBuilder> implements VisitableBuilder<PolicyV1beta1PodSecurityPolicy,PolicyV1beta1PodSecurityPolicyBuilder>{

    PolicyV1beta1PodSecurityPolicyFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1PodSecurityPolicyBuilder(){
            this(true);
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1PodSecurityPolicy(), validationEnabled);
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(PolicyV1beta1PodSecurityPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(PolicyV1beta1PodSecurityPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1PodSecurityPolicy(), validationEnabled);
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(PolicyV1beta1PodSecurityPolicyFluent<?> fluent,PolicyV1beta1PodSecurityPolicy instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(PolicyV1beta1PodSecurityPolicyFluent<?> fluent,PolicyV1beta1PodSecurityPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(PolicyV1beta1PodSecurityPolicy instance){
            this(instance,true);
    }
    public PolicyV1beta1PodSecurityPolicyBuilder(PolicyV1beta1PodSecurityPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1PodSecurityPolicy build(){
            PolicyV1beta1PodSecurityPolicy buildable = new PolicyV1beta1PodSecurityPolicy();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1PodSecurityPolicyBuilder that = (PolicyV1beta1PodSecurityPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
