package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PolicyV1beta1HostPortRangeBuilder extends PolicyV1beta1HostPortRangeFluentImpl<PolicyV1beta1HostPortRangeBuilder> implements VisitableBuilder<PolicyV1beta1HostPortRange,PolicyV1beta1HostPortRangeBuilder>{

    PolicyV1beta1HostPortRangeFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyV1beta1HostPortRangeBuilder(){
            this(true);
    }
    public PolicyV1beta1HostPortRangeBuilder(Boolean validationEnabled){
            this(new PolicyV1beta1HostPortRange(), validationEnabled);
    }
    public PolicyV1beta1HostPortRangeBuilder(PolicyV1beta1HostPortRangeFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyV1beta1HostPortRangeBuilder(PolicyV1beta1HostPortRangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new PolicyV1beta1HostPortRange(), validationEnabled);
    }
    public PolicyV1beta1HostPortRangeBuilder(PolicyV1beta1HostPortRangeFluent<?> fluent,PolicyV1beta1HostPortRange instance){
            this(fluent, instance, true);
    }
    public PolicyV1beta1HostPortRangeBuilder(PolicyV1beta1HostPortRangeFluent<?> fluent,PolicyV1beta1HostPortRange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMax(instance.getMax());

            fluent.withMin(instance.getMin());

            this.validationEnabled = validationEnabled; 
    }
    public PolicyV1beta1HostPortRangeBuilder(PolicyV1beta1HostPortRange instance){
            this(instance,true);
    }
    public PolicyV1beta1HostPortRangeBuilder(PolicyV1beta1HostPortRange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMax(instance.getMax());

            this.withMin(instance.getMin());

            this.validationEnabled = validationEnabled; 
    }

    public PolicyV1beta1HostPortRange build(){
            PolicyV1beta1HostPortRange buildable = new PolicyV1beta1HostPortRange();
            buildable.setMax(fluent.getMax());
            buildable.setMin(fluent.getMin());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyV1beta1HostPortRangeBuilder that = (PolicyV1beta1HostPortRangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
