package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder extends ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluentImpl<ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder> implements VisitableBuilder<ExtensionsV1beta1SupplementalGroupsStrategyOptions,ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder>{

    ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(){
            this(true);
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1SupplementalGroupsStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1SupplementalGroupsStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent,ExtensionsV1beta1SupplementalGroupsStrategyOptions instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(ExtensionsV1beta1SupplementalGroupsStrategyOptionsFluent<?> fluent,ExtensionsV1beta1SupplementalGroupsStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges());

            fluent.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(ExtensionsV1beta1SupplementalGroupsStrategyOptions instance){
            this(instance,true);
    }
    public ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder(ExtensionsV1beta1SupplementalGroupsStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1SupplementalGroupsStrategyOptions build(){
            ExtensionsV1beta1SupplementalGroupsStrategyOptions buildable = new ExtensionsV1beta1SupplementalGroupsStrategyOptions();
            buildable.setRanges(fluent.getRanges());
            buildable.setRule(fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder that = (ExtensionsV1beta1SupplementalGroupsStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
