package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1ScaleStatusBuilder extends ExtensionsV1beta1ScaleStatusFluentImpl<ExtensionsV1beta1ScaleStatusBuilder> implements VisitableBuilder<ExtensionsV1beta1ScaleStatus,ExtensionsV1beta1ScaleStatusBuilder>{

    ExtensionsV1beta1ScaleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1ScaleStatusBuilder(){
            this(true);
    }
    public ExtensionsV1beta1ScaleStatusBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1ScaleStatus(), validationEnabled);
    }
    public ExtensionsV1beta1ScaleStatusBuilder(ExtensionsV1beta1ScaleStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1ScaleStatusBuilder(ExtensionsV1beta1ScaleStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1ScaleStatus(), validationEnabled);
    }
    public ExtensionsV1beta1ScaleStatusBuilder(ExtensionsV1beta1ScaleStatusFluent<?> fluent,ExtensionsV1beta1ScaleStatus instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1ScaleStatusBuilder(ExtensionsV1beta1ScaleStatusFluent<?> fluent,ExtensionsV1beta1ScaleStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas());

            fluent.withSelector(instance.getSelector());

            fluent.withTargetSelector(instance.getTargetSelector());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1ScaleStatusBuilder(ExtensionsV1beta1ScaleStatus instance){
            this(instance,true);
    }
    public ExtensionsV1beta1ScaleStatusBuilder(ExtensionsV1beta1ScaleStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas());

            this.withSelector(instance.getSelector());

            this.withTargetSelector(instance.getTargetSelector());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1ScaleStatus build(){
            ExtensionsV1beta1ScaleStatus buildable = new ExtensionsV1beta1ScaleStatus();
            buildable.setReplicas(fluent.getReplicas());
            buildable.setSelector(fluent.getSelector());
            buildable.setTargetSelector(fluent.getTargetSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1ScaleStatusBuilder that = (ExtensionsV1beta1ScaleStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
