package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder extends ExtensionsV1beta1RuntimeClassStrategyOptionsFluentImpl<ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder> implements VisitableBuilder<ExtensionsV1beta1RuntimeClassStrategyOptions,ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder>{

    ExtensionsV1beta1RuntimeClassStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(){
            this(true);
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1RuntimeClassStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(ExtensionsV1beta1RuntimeClassStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(ExtensionsV1beta1RuntimeClassStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1RuntimeClassStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(ExtensionsV1beta1RuntimeClassStrategyOptionsFluent<?> fluent,ExtensionsV1beta1RuntimeClassStrategyOptions instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(ExtensionsV1beta1RuntimeClassStrategyOptionsFluent<?> fluent,ExtensionsV1beta1RuntimeClassStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());

            fluent.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(ExtensionsV1beta1RuntimeClassStrategyOptions instance){
            this(instance,true);
    }
    public ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder(ExtensionsV1beta1RuntimeClassStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());

            this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1RuntimeClassStrategyOptions build(){
            ExtensionsV1beta1RuntimeClassStrategyOptions buildable = new ExtensionsV1beta1RuntimeClassStrategyOptions();
            buildable.setAllowedRuntimeClassNames(fluent.getAllowedRuntimeClassNames());
            buildable.setDefaultRuntimeClassName(fluent.getDefaultRuntimeClassName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder that = (ExtensionsV1beta1RuntimeClassStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
