package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder extends ExtensionsV1beta1RunAsGroupStrategyOptionsFluentImpl<ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder> implements VisitableBuilder<ExtensionsV1beta1RunAsGroupStrategyOptions,ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder>{

    ExtensionsV1beta1RunAsGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(){
            this(true);
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1RunAsGroupStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(ExtensionsV1beta1RunAsGroupStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(ExtensionsV1beta1RunAsGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1RunAsGroupStrategyOptions(), validationEnabled);
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(ExtensionsV1beta1RunAsGroupStrategyOptionsFluent<?> fluent,ExtensionsV1beta1RunAsGroupStrategyOptions instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(ExtensionsV1beta1RunAsGroupStrategyOptionsFluent<?> fluent,ExtensionsV1beta1RunAsGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges());

            fluent.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(ExtensionsV1beta1RunAsGroupStrategyOptions instance){
            this(instance,true);
    }
    public ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder(ExtensionsV1beta1RunAsGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges());

            this.withRule(instance.getRule());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1RunAsGroupStrategyOptions build(){
            ExtensionsV1beta1RunAsGroupStrategyOptions buildable = new ExtensionsV1beta1RunAsGroupStrategyOptions();
            buildable.setRanges(fluent.getRanges());
            buildable.setRule(fluent.getRule());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder that = (ExtensionsV1beta1RunAsGroupStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
