/*
Copyright 2020 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

/**
 * IngressRule represents the rules mapping the paths under a specified host to the related backend
 * services. Incoming requests are first evaluated for a host match, then routed to the backend
 * associated with the matching IngressRuleValue.
 */
@ApiModel(
    description =
        "IngressRule represents the rules mapping the paths under a specified host to the related backend services. Incoming requests are first evaluated for a host match, then routed to the backend associated with the matching IngressRuleValue.")
@javax.annotation.Generated(
    value = "org.openapitools.codegen.languages.JavaClientCodegen",
    date = "2020-06-19T10:47:33.387Z[Etc/UTC]")
public class ExtensionsV1beta1IngressRule {
  public static final String SERIALIZED_NAME_HOST = "host";

  @SerializedName(SERIALIZED_NAME_HOST)
  private String host;

  public static final String SERIALIZED_NAME_HTTP = "http";

  @SerializedName(SERIALIZED_NAME_HTTP)
  private ExtensionsV1beta1HTTPIngressRuleValue http;

  public ExtensionsV1beta1IngressRule host(String host) {

    this.host = host;
    return this;
  }

  /**
   * Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the
   * following deviations from the \&quot;host\&quot; part of the URI as defined in the RFC: 1. IPs
   * are not allowed. Currently an IngressRuleValue can only apply to the IP in the Spec of the
   * parent Ingress. 2. The &#x60;:&#x60; delimiter is not respected because ports are not allowed.
   * Currently the port of an Ingress is implicitly :80 for http and :443 for https. Both these may
   * change in the future. Incoming requests are matched against the host before the
   * IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the
   * specified IngressRuleValue.
   *
   * @return host
   */
  @javax.annotation.Nullable
  @ApiModelProperty(
      value =
          "Host is the fully qualified domain name of a network host, as defined by RFC 3986. Note the following deviations from the \"host\" part of the URI as defined in the RFC: 1. IPs are not allowed. Currently an IngressRuleValue can only apply to the    IP in the Spec of the parent Ingress. 2. The `:` delimiter is not respected because ports are not allowed.    Currently the port of an Ingress is implicitly :80 for http and    :443 for https. Both these may change in the future. Incoming requests are matched against the host before the IngressRuleValue. If the host is unspecified, the Ingress routes all traffic based on the specified IngressRuleValue.")
  public String getHost() {
    return host;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public ExtensionsV1beta1IngressRule http(ExtensionsV1beta1HTTPIngressRuleValue http) {

    this.http = http;
    return this;
  }

  /**
   * Get http
   *
   * @return http
   */
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  public ExtensionsV1beta1HTTPIngressRuleValue getHttp() {
    return http;
  }

  public void setHttp(ExtensionsV1beta1HTTPIngressRuleValue http) {
    this.http = http;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtensionsV1beta1IngressRule extensionsV1beta1IngressRule = (ExtensionsV1beta1IngressRule) o;
    return Objects.equals(this.host, extensionsV1beta1IngressRule.host)
        && Objects.equals(this.http, extensionsV1beta1IngressRule.http);
  }

  @Override
  public int hashCode() {
    return Objects.hash(host, http);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtensionsV1beta1IngressRule {\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    http: ").append(toIndentedString(http)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
