package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1HostPortRangeBuilder extends ExtensionsV1beta1HostPortRangeFluentImpl<ExtensionsV1beta1HostPortRangeBuilder> implements VisitableBuilder<ExtensionsV1beta1HostPortRange,ExtensionsV1beta1HostPortRangeBuilder>{

    ExtensionsV1beta1HostPortRangeFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1HostPortRangeBuilder(){
            this(true);
    }
    public ExtensionsV1beta1HostPortRangeBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1HostPortRange(), validationEnabled);
    }
    public ExtensionsV1beta1HostPortRangeBuilder(ExtensionsV1beta1HostPortRangeFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1HostPortRangeBuilder(ExtensionsV1beta1HostPortRangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1HostPortRange(), validationEnabled);
    }
    public ExtensionsV1beta1HostPortRangeBuilder(ExtensionsV1beta1HostPortRangeFluent<?> fluent,ExtensionsV1beta1HostPortRange instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1HostPortRangeBuilder(ExtensionsV1beta1HostPortRangeFluent<?> fluent,ExtensionsV1beta1HostPortRange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMax(instance.getMax());

            fluent.withMin(instance.getMin());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1HostPortRangeBuilder(ExtensionsV1beta1HostPortRange instance){
            this(instance,true);
    }
    public ExtensionsV1beta1HostPortRangeBuilder(ExtensionsV1beta1HostPortRange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMax(instance.getMax());

            this.withMin(instance.getMin());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1HostPortRange build(){
            ExtensionsV1beta1HostPortRange buildable = new ExtensionsV1beta1HostPortRange();
            buildable.setMax(fluent.getMax());
            buildable.setMin(fluent.getMin());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1HostPortRangeBuilder that = (ExtensionsV1beta1HostPortRangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
