package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentStrategyBuilder extends ExtensionsV1beta1DeploymentStrategyFluentImpl<ExtensionsV1beta1DeploymentStrategyBuilder> implements VisitableBuilder<ExtensionsV1beta1DeploymentStrategy,ExtensionsV1beta1DeploymentStrategyBuilder>{

    ExtensionsV1beta1DeploymentStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1DeploymentStrategyBuilder(){
            this(true);
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1DeploymentStrategy(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(ExtensionsV1beta1DeploymentStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(ExtensionsV1beta1DeploymentStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1DeploymentStrategy(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(ExtensionsV1beta1DeploymentStrategyFluent<?> fluent,ExtensionsV1beta1DeploymentStrategy instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(ExtensionsV1beta1DeploymentStrategyFluent<?> fluent,ExtensionsV1beta1DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRollingUpdate(instance.getRollingUpdate());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(ExtensionsV1beta1DeploymentStrategy instance){
            this(instance,true);
    }
    public ExtensionsV1beta1DeploymentStrategyBuilder(ExtensionsV1beta1DeploymentStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1DeploymentStrategy build(){
            ExtensionsV1beta1DeploymentStrategy buildable = new ExtensionsV1beta1DeploymentStrategy();
            buildable.setRollingUpdate(fluent.getRollingUpdate());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentStrategyBuilder that = (ExtensionsV1beta1DeploymentStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
