package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentSpecBuilder extends ExtensionsV1beta1DeploymentSpecFluentImpl<ExtensionsV1beta1DeploymentSpecBuilder> implements VisitableBuilder<ExtensionsV1beta1DeploymentSpec,ExtensionsV1beta1DeploymentSpecBuilder>{

    ExtensionsV1beta1DeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1DeploymentSpecBuilder(){
            this(true);
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1DeploymentSpec(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(ExtensionsV1beta1DeploymentSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(ExtensionsV1beta1DeploymentSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1DeploymentSpec(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(ExtensionsV1beta1DeploymentSpecFluent<?> fluent,ExtensionsV1beta1DeploymentSpec instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(ExtensionsV1beta1DeploymentSpecFluent<?> fluent,ExtensionsV1beta1DeploymentSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinReadySeconds(instance.getMinReadySeconds());

            fluent.withPaused(instance.getPaused());

            fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            fluent.withReplicas(instance.getReplicas());

            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            fluent.withRollbackTo(instance.getRollbackTo());

            fluent.withSelector(instance.getSelector());

            fluent.withStrategy(instance.getStrategy());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(ExtensionsV1beta1DeploymentSpec instance){
            this(instance,true);
    }
    public ExtensionsV1beta1DeploymentSpecBuilder(ExtensionsV1beta1DeploymentSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withPaused(instance.getPaused());

            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withRollbackTo(instance.getRollbackTo());

            this.withSelector(instance.getSelector());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1DeploymentSpec build(){
            ExtensionsV1beta1DeploymentSpec buildable = new ExtensionsV1beta1DeploymentSpec();
            buildable.setMinReadySeconds(fluent.getMinReadySeconds());
            buildable.setPaused(fluent.isPaused());
            buildable.setProgressDeadlineSeconds(fluent.getProgressDeadlineSeconds());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setRevisionHistoryLimit(fluent.getRevisionHistoryLimit());
            buildable.setRollbackTo(fluent.getRollbackTo());
            buildable.setSelector(fluent.getSelector());
            buildable.setStrategy(fluent.getStrategy());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentSpecBuilder that = (ExtensionsV1beta1DeploymentSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
