package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentRollbackBuilder extends ExtensionsV1beta1DeploymentRollbackFluentImpl<ExtensionsV1beta1DeploymentRollbackBuilder> implements VisitableBuilder<ExtensionsV1beta1DeploymentRollback,ExtensionsV1beta1DeploymentRollbackBuilder>{

    ExtensionsV1beta1DeploymentRollbackFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1DeploymentRollbackBuilder(){
            this(true);
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1DeploymentRollback(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(ExtensionsV1beta1DeploymentRollbackFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(ExtensionsV1beta1DeploymentRollbackFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1DeploymentRollback(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(ExtensionsV1beta1DeploymentRollbackFluent<?> fluent,ExtensionsV1beta1DeploymentRollback instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(ExtensionsV1beta1DeploymentRollbackFluent<?> fluent,ExtensionsV1beta1DeploymentRollback instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withName(instance.getName());

            fluent.withRollbackTo(instance.getRollbackTo());

            fluent.withUpdatedAnnotations(instance.getUpdatedAnnotations());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(ExtensionsV1beta1DeploymentRollback instance){
            this(instance,true);
    }
    public ExtensionsV1beta1DeploymentRollbackBuilder(ExtensionsV1beta1DeploymentRollback instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withName(instance.getName());

            this.withRollbackTo(instance.getRollbackTo());

            this.withUpdatedAnnotations(instance.getUpdatedAnnotations());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1DeploymentRollback build(){
            ExtensionsV1beta1DeploymentRollback buildable = new ExtensionsV1beta1DeploymentRollback();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setName(fluent.getName());
            buildable.setRollbackTo(fluent.getRollbackTo());
            buildable.setUpdatedAnnotations(fluent.getUpdatedAnnotations());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentRollbackBuilder that = (ExtensionsV1beta1DeploymentRollbackBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
