package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1AllowedCSIDriverBuilder extends ExtensionsV1beta1AllowedCSIDriverFluentImpl<ExtensionsV1beta1AllowedCSIDriverBuilder> implements VisitableBuilder<ExtensionsV1beta1AllowedCSIDriver,ExtensionsV1beta1AllowedCSIDriverBuilder>{

    ExtensionsV1beta1AllowedCSIDriverFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1AllowedCSIDriverBuilder(){
            this(true);
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1AllowedCSIDriver(), validationEnabled);
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(ExtensionsV1beta1AllowedCSIDriverFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(ExtensionsV1beta1AllowedCSIDriverFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1AllowedCSIDriver(), validationEnabled);
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(ExtensionsV1beta1AllowedCSIDriverFluent<?> fluent,ExtensionsV1beta1AllowedCSIDriver instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(ExtensionsV1beta1AllowedCSIDriverFluent<?> fluent,ExtensionsV1beta1AllowedCSIDriver instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(ExtensionsV1beta1AllowedCSIDriver instance){
            this(instance,true);
    }
    public ExtensionsV1beta1AllowedCSIDriverBuilder(ExtensionsV1beta1AllowedCSIDriver instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1AllowedCSIDriver build(){
            ExtensionsV1beta1AllowedCSIDriver buildable = new ExtensionsV1beta1AllowedCSIDriver();
            buildable.setName(fluent.getName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1AllowedCSIDriverBuilder that = (ExtensionsV1beta1AllowedCSIDriverBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
