package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1RollbackConfigBuilder extends AppsV1beta1RollbackConfigFluentImpl<AppsV1beta1RollbackConfigBuilder> implements VisitableBuilder<AppsV1beta1RollbackConfig,AppsV1beta1RollbackConfigBuilder>{

    AppsV1beta1RollbackConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1RollbackConfigBuilder(){
            this(true);
    }
    public AppsV1beta1RollbackConfigBuilder(Boolean validationEnabled){
            this(new AppsV1beta1RollbackConfig(), validationEnabled);
    }
    public AppsV1beta1RollbackConfigBuilder(AppsV1beta1RollbackConfigFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1RollbackConfigBuilder(AppsV1beta1RollbackConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1RollbackConfig(), validationEnabled);
    }
    public AppsV1beta1RollbackConfigBuilder(AppsV1beta1RollbackConfigFluent<?> fluent,AppsV1beta1RollbackConfig instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1RollbackConfigBuilder(AppsV1beta1RollbackConfigFluent<?> fluent,AppsV1beta1RollbackConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1RollbackConfigBuilder(AppsV1beta1RollbackConfig instance){
            this(instance,true);
    }
    public AppsV1beta1RollbackConfigBuilder(AppsV1beta1RollbackConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1RollbackConfig build(){
            AppsV1beta1RollbackConfig buildable = new AppsV1beta1RollbackConfig();
            buildable.setRevision(fluent.getRevision());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1RollbackConfigBuilder that = (AppsV1beta1RollbackConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
