package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface AppsV1beta1DeploymentStatusFluent<A extends AppsV1beta1DeploymentStatusFluent<A>> extends Fluent<A>{


    public Integer getAvailableReplicas();
    public A withAvailableReplicas(Integer availableReplicas);
    public Boolean hasAvailableReplicas();
    public Integer getCollisionCount();
    public A withCollisionCount(Integer collisionCount);
    public Boolean hasCollisionCount();
    public A addToConditions(int index,AppsV1beta1DeploymentCondition item);
    public A setToConditions(int index,AppsV1beta1DeploymentCondition item);
    public A addToConditions(AppsV1beta1DeploymentCondition... items);
    public A addAllToConditions(Collection<AppsV1beta1DeploymentCondition> items);
    public A removeFromConditions(AppsV1beta1DeploymentCondition... items);
    public A removeAllFromConditions(Collection<AppsV1beta1DeploymentCondition> items);
    public A removeMatchingFromConditions(io.kubernetes.client.fluent.Predicate<AppsV1beta1DeploymentConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<AppsV1beta1DeploymentCondition> getConditions();
    public List<AppsV1beta1DeploymentCondition> buildConditions();
    public AppsV1beta1DeploymentCondition buildCondition(int index);
    public AppsV1beta1DeploymentCondition buildFirstCondition();
    public AppsV1beta1DeploymentCondition buildLastCondition();
    public AppsV1beta1DeploymentCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<AppsV1beta1DeploymentConditionBuilder> predicate);
    public Boolean hasMatchingCondition(io.kubernetes.client.fluent.Predicate<AppsV1beta1DeploymentConditionBuilder> predicate);
    public A withConditions(List<AppsV1beta1DeploymentCondition> conditions);
    public A withConditions(AppsV1beta1DeploymentCondition... conditions);
    public Boolean hasConditions();
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> addNewCondition();
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> addNewConditionLike(AppsV1beta1DeploymentCondition item);
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> setNewConditionLike(int index,AppsV1beta1DeploymentCondition item);
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> editCondition(int index);
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> editFirstCondition();
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> editLastCondition();
    public AppsV1beta1DeploymentStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<AppsV1beta1DeploymentConditionBuilder> predicate);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public Integer getReadyReplicas();
    public A withReadyReplicas(Integer readyReplicas);
    public Boolean hasReadyReplicas();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public Integer getUnavailableReplicas();
    public A withUnavailableReplicas(Integer unavailableReplicas);
    public Boolean hasUnavailableReplicas();
    public Integer getUpdatedReplicas();
    public A withUpdatedReplicas(Integer updatedReplicas);
    public Boolean hasUpdatedReplicas();

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,AppsV1beta1DeploymentConditionFluent<AppsV1beta1DeploymentStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}


}
