package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1DeploymentStatusBuilder extends AppsV1beta1DeploymentStatusFluentImpl<AppsV1beta1DeploymentStatusBuilder> implements VisitableBuilder<AppsV1beta1DeploymentStatus,AppsV1beta1DeploymentStatusBuilder>{

    AppsV1beta1DeploymentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1DeploymentStatusBuilder(){
            this(true);
    }
    public AppsV1beta1DeploymentStatusBuilder(Boolean validationEnabled){
            this(new AppsV1beta1DeploymentStatus(), validationEnabled);
    }
    public AppsV1beta1DeploymentStatusBuilder(AppsV1beta1DeploymentStatusFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1DeploymentStatusBuilder(AppsV1beta1DeploymentStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1DeploymentStatus(), validationEnabled);
    }
    public AppsV1beta1DeploymentStatusBuilder(AppsV1beta1DeploymentStatusFluent<?> fluent,AppsV1beta1DeploymentStatus instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1DeploymentStatusBuilder(AppsV1beta1DeploymentStatusFluent<?> fluent,AppsV1beta1DeploymentStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAvailableReplicas(instance.getAvailableReplicas());

            fluent.withCollisionCount(instance.getCollisionCount());

            fluent.withConditions(instance.getConditions());

            fluent.withObservedGeneration(instance.getObservedGeneration());

            fluent.withReadyReplicas(instance.getReadyReplicas());

            fluent.withReplicas(instance.getReplicas());

            fluent.withUnavailableReplicas(instance.getUnavailableReplicas());

            fluent.withUpdatedReplicas(instance.getUpdatedReplicas());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1DeploymentStatusBuilder(AppsV1beta1DeploymentStatus instance){
            this(instance,true);
    }
    public AppsV1beta1DeploymentStatusBuilder(AppsV1beta1DeploymentStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAvailableReplicas(instance.getAvailableReplicas());

            this.withCollisionCount(instance.getCollisionCount());

            this.withConditions(instance.getConditions());

            this.withObservedGeneration(instance.getObservedGeneration());

            this.withReadyReplicas(instance.getReadyReplicas());

            this.withReplicas(instance.getReplicas());

            this.withUnavailableReplicas(instance.getUnavailableReplicas());

            this.withUpdatedReplicas(instance.getUpdatedReplicas());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1DeploymentStatus build(){
            AppsV1beta1DeploymentStatus buildable = new AppsV1beta1DeploymentStatus();
            buildable.setAvailableReplicas(fluent.getAvailableReplicas());
            buildable.setCollisionCount(fluent.getCollisionCount());
            buildable.setConditions(fluent.getConditions());
            buildable.setObservedGeneration(fluent.getObservedGeneration());
            buildable.setReadyReplicas(fluent.getReadyReplicas());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setUnavailableReplicas(fluent.getUnavailableReplicas());
            buildable.setUpdatedReplicas(fluent.getUpdatedReplicas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1DeploymentStatusBuilder that = (AppsV1beta1DeploymentStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
