/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="The device this taint is attached to has the \"effect\" on any claim which does not tolerate the taint and, through the claim, to pods using the claim.")
public class V1beta2DeviceTaint {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    @Nonnull
    private String effect;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_TIME_ADDED = "timeAdded";
    @SerializedName(value="timeAdded")
    @Nullable
    private OffsetDateTime timeAdded;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    @Nullable
    private String value;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceTaint effect(@Nonnull String effect) {
        this.effect = effect;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The effect of the taint on claims that do not tolerate the taint and through such claims on the pods using them. Valid effects are NoSchedule and NoExecute. PreferNoSchedule as used for nodes is not valid here.")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(@Nonnull String effect) {
        this.effect = effect;
    }

    public V1beta2DeviceTaint key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The taint key to be applied to a device. Must be a label name.")
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public V1beta2DeviceTaint timeAdded(@Nullable OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TimeAdded represents the time at which the taint was added. Added automatically during create or update if not set.")
    public OffsetDateTime getTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(@Nullable OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
    }

    public V1beta2DeviceTaint value(@Nullable String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The taint value corresponding to the taint key. Must be a label value.")
    public String getValue() {
        return this.value;
    }

    public void setValue(@Nullable String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceTaint v1beta2DeviceTaint = (V1beta2DeviceTaint)o;
        return Objects.equals(this.effect, v1beta2DeviceTaint.effect) && Objects.equals(this.key, v1beta2DeviceTaint.key) && Objects.equals(this.timeAdded, v1beta2DeviceTaint.timeAdded) && Objects.equals(this.value, v1beta2DeviceTaint.value);
    }

    public int hashCode() {
        return Objects.hash(this.effect, this.key, this.timeAdded, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceTaint {\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timeAdded: ").append(this.toIndentedString(this.timeAdded)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceTaint is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceTaint` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_EFFECT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `effect` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EFFECT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUE) != null && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALUE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `value` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUE).toString()));
        }
    }

    public static V1beta2DeviceTaint fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceTaint)JSON.getGson().fromJson(jsonString, V1beta2DeviceTaint.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EFFECT);
        openapiFields.add(SERIALIZED_NAME_KEY);
        openapiFields.add(SERIALIZED_NAME_TIME_ADDED);
        openapiFields.add(SERIALIZED_NAME_VALUE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_EFFECT);
        openapiRequiredFields.add(SERIALIZED_NAME_KEY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceTaint.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceTaint.class));
            return new TypeAdapter<V1beta2DeviceTaint>(){

                public void write(JsonWriter out, V1beta2DeviceTaint value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceTaint read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceTaint.validateJsonElement(jsonElement);
                    return (V1beta2DeviceTaint)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

