/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceConstraint must have exactly one field set besides Requests.")
public class V1beta2DeviceConstraint {
    public static final String SERIALIZED_NAME_DISTINCT_ATTRIBUTE = "distinctAttribute";
    @SerializedName(value="distinctAttribute")
    @Nullable
    private String distinctAttribute;
    public static final String SERIALIZED_NAME_MATCH_ATTRIBUTE = "matchAttribute";
    @SerializedName(value="matchAttribute")
    @Nullable
    private String matchAttribute;
    public static final String SERIALIZED_NAME_REQUESTS = "requests";
    @SerializedName(value="requests")
    @Nullable
    private List<String> requests = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta2DeviceConstraint distinctAttribute(@Nullable String distinctAttribute) {
        this.distinctAttribute = distinctAttribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DistinctAttribute requires that all devices in question have this attribute and that its type and value are unique across those devices.  This acts as the inverse of MatchAttribute.  This constraint is used to avoid allocating multiple requests to the same device by ensuring attribute-level differentiation.  This is useful for scenarios where resource requests must be fulfilled by separate physical devices. For example, a container requests two network interfaces that must be allocated from two different physical NICs.")
    public String getDistinctAttribute() {
        return this.distinctAttribute;
    }

    public void setDistinctAttribute(@Nullable String distinctAttribute) {
        this.distinctAttribute = distinctAttribute;
    }

    public V1beta2DeviceConstraint matchAttribute(@Nullable String matchAttribute) {
        this.matchAttribute = matchAttribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MatchAttribute requires that all devices in question have this attribute and that its type and value are the same across those devices.  For example, if you specified \"dra.example.com/numa\" (a hypothetical example!), then only devices in the same NUMA node will be chosen. A device which does not have that attribute will not be chosen. All devices should use a value of the same type for this attribute because that is part of its specification, but if one device doesn't, then it also will not be chosen.  Must include the domain qualifier.")
    public String getMatchAttribute() {
        return this.matchAttribute;
    }

    public void setMatchAttribute(@Nullable String matchAttribute) {
        this.matchAttribute = matchAttribute;
    }

    public V1beta2DeviceConstraint requests(@Nullable List<String> requests) {
        this.requests = requests;
        return this;
    }

    public V1beta2DeviceConstraint addRequestsItem(String requestsItem) {
        if (this.requests == null) {
            this.requests = new ArrayList<String>();
        }
        this.requests.add(requestsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requests is a list of the one or more requests in this claim which must co-satisfy this constraint. If a request is fulfilled by multiple devices, then all of the devices must satisfy the constraint. If this is not specified, this constraint applies to all requests in this claim.  References to subrequests must include the name of the main request and may include the subrequest using the format <main request>[/<subrequest>]. If just the main request is given, the constraint applies to all subrequests.")
    public List<String> getRequests() {
        return this.requests;
    }

    public void setRequests(@Nullable List<String> requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2DeviceConstraint v1beta2DeviceConstraint = (V1beta2DeviceConstraint)o;
        return Objects.equals(this.distinctAttribute, v1beta2DeviceConstraint.distinctAttribute) && Objects.equals(this.matchAttribute, v1beta2DeviceConstraint.matchAttribute) && Objects.equals(this.requests, v1beta2DeviceConstraint.requests);
    }

    public int hashCode() {
        return Objects.hash(this.distinctAttribute, this.matchAttribute, this.requests);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2DeviceConstraint {\n");
        sb.append("    distinctAttribute: ").append(this.toIndentedString(this.distinctAttribute)).append("\n");
        sb.append("    matchAttribute: ").append(this.toIndentedString(this.matchAttribute)).append("\n");
        sb.append("    requests: ").append(this.toIndentedString(this.requests)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta2DeviceConstraint is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta2DeviceConstraint` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DISTINCT_ATTRIBUTE) != null && !jsonObj.get(SERIALIZED_NAME_DISTINCT_ATTRIBUTE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DISTINCT_ATTRIBUTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `distinctAttribute` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DISTINCT_ATTRIBUTE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MATCH_ATTRIBUTE) != null && !jsonObj.get(SERIALIZED_NAME_MATCH_ATTRIBUTE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MATCH_ATTRIBUTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `matchAttribute` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MATCH_ATTRIBUTE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTS) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUESTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `requests` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTS).toString()));
        }
    }

    public static V1beta2DeviceConstraint fromJson(String jsonString) throws IOException {
        return (V1beta2DeviceConstraint)JSON.getGson().fromJson(jsonString, V1beta2DeviceConstraint.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DISTINCT_ATTRIBUTE);
        openapiFields.add(SERIALIZED_NAME_MATCH_ATTRIBUTE);
        openapiFields.add(SERIALIZED_NAME_REQUESTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta2DeviceConstraint.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta2DeviceConstraint.class));
            return new TypeAdapter<V1beta2DeviceConstraint>(){

                public void write(JsonWriter out, V1beta2DeviceConstraint value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta2DeviceConstraint read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta2DeviceConstraint.validateJsonElement(jsonElement);
                    return (V1beta2DeviceConstraint)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

