/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="VolumeMount describes a mounting of a Volume within a container.")
public class V1VolumeMount {
    public static final String SERIALIZED_NAME_MOUNT_PATH = "mountPath";
    @SerializedName(value="mountPath")
    @Nonnull
    private String mountPath;
    public static final String SERIALIZED_NAME_MOUNT_PROPAGATION = "mountPropagation";
    @SerializedName(value="mountPropagation")
    @Nullable
    private String mountPropagation;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_RECURSIVE_READ_ONLY = "recursiveReadOnly";
    @SerializedName(value="recursiveReadOnly")
    @Nullable
    private String recursiveReadOnly;
    public static final String SERIALIZED_NAME_SUB_PATH = "subPath";
    @SerializedName(value="subPath")
    @Nullable
    private String subPath;
    public static final String SERIALIZED_NAME_SUB_PATH_EXPR = "subPathExpr";
    @SerializedName(value="subPathExpr")
    @Nullable
    private String subPathExpr;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1VolumeMount mountPath(@Nonnull String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Path within the container at which the volume should be mounted.  Must not contain ':'.")
    public String getMountPath() {
        return this.mountPath;
    }

    public void setMountPath(@Nonnull String mountPath) {
        this.mountPath = mountPath;
    }

    public V1VolumeMount mountPropagation(@Nullable String mountPropagation) {
        this.mountPropagation = mountPropagation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10. When RecursiveReadOnly is set to IfPossible or to Enabled, MountPropagation must be None or unspecified (which defaults to None).")
    public String getMountPropagation() {
        return this.mountPropagation;
    }

    public void setMountPropagation(@Nullable String mountPropagation) {
        this.mountPropagation = mountPropagation;
    }

    public V1VolumeMount name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="This must match the Name of a Volume.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1VolumeMount readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1VolumeMount recursiveReadOnly(@Nullable String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RecursiveReadOnly specifies whether read-only mounts should be handled recursively.  If ReadOnly is false, this field has no meaning and must be unspecified.  If ReadOnly is true, and this field is set to Disabled, the mount is not made recursively read-only.  If this field is set to IfPossible, the mount is made recursively read-only, if it is supported by the container runtime.  If this field is set to Enabled, the mount is made recursively read-only if it is supported by the container runtime, otherwise the pod will not be started and an error will be generated to indicate the reason.  If this field is set to IfPossible or Enabled, MountPropagation must be set to None (or be unspecified, which defaults to None).  If this field is not specified, it is treated as an equivalent of Disabled.")
    public String getRecursiveReadOnly() {
        return this.recursiveReadOnly;
    }

    public void setRecursiveReadOnly(@Nullable String recursiveReadOnly) {
        this.recursiveReadOnly = recursiveReadOnly;
    }

    public V1VolumeMount subPath(@Nullable String subPath) {
        this.subPath = subPath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path within the volume from which the container's volume should be mounted. Defaults to \"\" (volume's root).")
    public String getSubPath() {
        return this.subPath;
    }

    public void setSubPath(@Nullable String subPath) {
        this.subPath = subPath;
    }

    public V1VolumeMount subPathExpr(@Nullable String subPathExpr) {
        this.subPathExpr = subPathExpr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to \"\" (volume's root). SubPathExpr and SubPath are mutually exclusive.")
    public String getSubPathExpr() {
        return this.subPathExpr;
    }

    public void setSubPathExpr(@Nullable String subPathExpr) {
        this.subPathExpr = subPathExpr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1VolumeMount v1VolumeMount = (V1VolumeMount)o;
        return Objects.equals(this.mountPath, v1VolumeMount.mountPath) && Objects.equals(this.mountPropagation, v1VolumeMount.mountPropagation) && Objects.equals(this.name, v1VolumeMount.name) && Objects.equals(this.readOnly, v1VolumeMount.readOnly) && Objects.equals(this.recursiveReadOnly, v1VolumeMount.recursiveReadOnly) && Objects.equals(this.subPath, v1VolumeMount.subPath) && Objects.equals(this.subPathExpr, v1VolumeMount.subPathExpr);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.mountPropagation, this.name, this.readOnly, this.recursiveReadOnly, this.subPath, this.subPathExpr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1VolumeMount {\n");
        sb.append("    mountPath: ").append(this.toIndentedString(this.mountPath)).append("\n");
        sb.append("    mountPropagation: ").append(this.toIndentedString(this.mountPropagation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    recursiveReadOnly: ").append(this.toIndentedString(this.recursiveReadOnly)).append("\n");
        sb.append("    subPath: ").append(this.toIndentedString(this.subPath)).append("\n");
        sb.append("    subPathExpr: ").append(this.toIndentedString(this.subPathExpr)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1VolumeMount is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1VolumeMount` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_MOUNT_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mountPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNT_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MOUNT_PROPAGATION) != null && !jsonObj.get(SERIALIZED_NAME_MOUNT_PROPAGATION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MOUNT_PROPAGATION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `mountPropagation` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOUNT_PROPAGATION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY) != null && !jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recursiveReadOnly` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECURSIVE_READ_ONLY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_PATH) != null && !jsonObj.get(SERIALIZED_NAME_SUB_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUB_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subPath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SUB_PATH_EXPR) != null && !jsonObj.get(SERIALIZED_NAME_SUB_PATH_EXPR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUB_PATH_EXPR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `subPathExpr` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUB_PATH_EXPR).toString()));
        }
    }

    public static V1VolumeMount fromJson(String jsonString) throws IOException {
        return (V1VolumeMount)JSON.getGson().fromJson(jsonString, V1VolumeMount.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MOUNT_PATH);
        openapiFields.add(SERIALIZED_NAME_MOUNT_PROPAGATION);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_RECURSIVE_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_SUB_PATH);
        openapiFields.add(SERIALIZED_NAME_SUB_PATH_EXPR);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_MOUNT_PATH);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1VolumeMount.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1VolumeMount.class));
            return new TypeAdapter<V1VolumeMount>(){

                public void write(JsonWriter out, V1VolumeMount value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1VolumeMount read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1VolumeMount.validateJsonElement(jsonElement);
                    return (V1VolumeMount)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

