/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PortStatus represents the error condition of a service port")
public class V1PortStatus {
    public static final String SERIALIZED_NAME_ERROR = "error";
    @SerializedName(value="error")
    @Nullable
    private String error;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    @Nonnull
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    @Nonnull
    private String protocol;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PortStatus error(@Nullable String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Error is to record the problem with the service port The format of the error shall comply with the following rules: - built-in error values shall be specified in this file and those shall use   CamelCase names - cloud provider specific error values must have names that comply with the   format foo.example.com/CamelCase.")
    public String getError() {
        return this.error;
    }

    public void setError(@Nullable String error) {
        this.error = error;
    }

    public V1PortStatus port(@Nonnull Integer port) {
        this.port = port;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Port is the port number of the service port of which status is recorded here")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(@Nonnull Integer port) {
        this.port = port;
    }

    public V1PortStatus protocol(@Nonnull String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Protocol is the protocol of the service port of which status is recorded here The supported values are: \"TCP\", \"UDP\", \"SCTP\"")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(@Nonnull String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PortStatus v1PortStatus = (V1PortStatus)o;
        return Objects.equals(this.error, v1PortStatus.error) && Objects.equals(this.port, v1PortStatus.port) && Objects.equals(this.protocol, v1PortStatus.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.error, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PortStatus {\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PortStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PortStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ERROR) != null && !jsonObj.get(SERIALIZED_NAME_ERROR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ERROR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `error` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PROTOCOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `protocol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROTOCOL).toString()));
        }
    }

    public static V1PortStatus fromJson(String jsonString) throws IOException {
        return (V1PortStatus)JSON.getGson().fromJson(jsonString, V1PortStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ERROR);
        openapiFields.add(SERIALIZED_NAME_PORT);
        openapiFields.add(SERIALIZED_NAME_PROTOCOL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_PORT);
        openapiRequiredFields.add(SERIALIZED_NAME_PROTOCOL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PortStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PortStatus.class));
            return new TypeAdapter<V1PortStatus>(){

                public void write(JsonWriter out, V1PortStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PortStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PortStatus.validateJsonElement(jsonElement);
                    return (V1PortStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

