/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodResourceClaim references exactly one ResourceClaim, either directly or by naming a ResourceClaimTemplate which is then turned into a ResourceClaim for the pod.  It adds a name to it that uniquely identifies the ResourceClaim inside the Pod. Containers that need access to the ResourceClaim reference it with this name.")
public class V1PodResourceClaim {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_NAME = "resourceClaimName";
    @SerializedName(value="resourceClaimName")
    @Nullable
    private String resourceClaimName;
    public static final String SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME = "resourceClaimTemplateName";
    @SerializedName(value="resourceClaimTemplateName")
    @Nullable
    private String resourceClaimTemplateName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PodResourceClaim name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name uniquely identifies this resource claim inside the pod. This must be a DNS_LABEL.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1PodResourceClaim resourceClaimName(@Nullable String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimName is the name of a ResourceClaim object in the same namespace as this pod.  Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.")
    public String getResourceClaimName() {
        return this.resourceClaimName;
    }

    public void setResourceClaimName(@Nullable String resourceClaimName) {
        this.resourceClaimName = resourceClaimName;
    }

    public V1PodResourceClaim resourceClaimTemplateName(@Nullable String resourceClaimTemplateName) {
        this.resourceClaimTemplateName = resourceClaimTemplateName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceClaimTemplateName is the name of a ResourceClaimTemplate object in the same namespace as this pod.  The template will be used to create a new ResourceClaim, which will be bound to this pod. When this pod is deleted, the ResourceClaim will also be deleted. The pod name and resource name, along with a generated component, will be used to form a unique name for the ResourceClaim, which will be recorded in pod.status.resourceClaimStatuses.  This field is immutable and no changes will be made to the corresponding ResourceClaim by the control plane after creating the ResourceClaim.  Exactly one of ResourceClaimName and ResourceClaimTemplateName must be set.")
    public String getResourceClaimTemplateName() {
        return this.resourceClaimTemplateName;
    }

    public void setResourceClaimTemplateName(@Nullable String resourceClaimTemplateName) {
        this.resourceClaimTemplateName = resourceClaimTemplateName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodResourceClaim v1PodResourceClaim = (V1PodResourceClaim)o;
        return Objects.equals(this.name, v1PodResourceClaim.name) && Objects.equals(this.resourceClaimName, v1PodResourceClaim.resourceClaimName) && Objects.equals(this.resourceClaimTemplateName, v1PodResourceClaim.resourceClaimTemplateName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.resourceClaimName, this.resourceClaimTemplateName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PodResourceClaim {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    resourceClaimName: ").append(this.toIndentedString(this.resourceClaimName)).append("\n");
        sb.append("    resourceClaimTemplateName: ").append(this.toIndentedString(this.resourceClaimTemplateName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PodResourceClaim is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PodResourceClaim` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceClaimName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceClaimTemplateName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME).toString()));
        }
    }

    public static V1PodResourceClaim fromJson(String jsonString) throws IOException {
        return (V1PodResourceClaim)JSON.getGson().fromJson(jsonString, V1PodResourceClaim.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLAIM_NAME);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_CLAIM_TEMPLATE_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PodResourceClaim.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PodResourceClaim.class));
            return new TypeAdapter<V1PodResourceClaim>(){

                public void write(JsonWriter out, V1PodResourceClaim value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PodResourceClaim read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PodResourceClaim.validateJsonElement(jsonElement);
                    return (V1PodResourceClaim)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

