/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="LinuxContainerUser represents user identity information in Linux containers")
public class V1LinuxContainerUser {
    public static final String SERIALIZED_NAME_GID = "gid";
    @SerializedName(value="gid")
    @Nonnull
    private Long gid;
    public static final String SERIALIZED_NAME_SUPPLEMENTAL_GROUPS = "supplementalGroups";
    @SerializedName(value="supplementalGroups")
    @Nullable
    private List<Long> supplementalGroups = new ArrayList<Long>();
    public static final String SERIALIZED_NAME_UID = "uid";
    @SerializedName(value="uid")
    @Nonnull
    private Long uid;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LinuxContainerUser gid(@Nonnull Long gid) {
        this.gid = gid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="GID is the primary gid initially attached to the first process in the container")
    public Long getGid() {
        return this.gid;
    }

    public void setGid(@Nonnull Long gid) {
        this.gid = gid;
    }

    public V1LinuxContainerUser supplementalGroups(@Nullable List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
        return this;
    }

    public V1LinuxContainerUser addSupplementalGroupsItem(Long supplementalGroupsItem) {
        if (this.supplementalGroups == null) {
            this.supplementalGroups = new ArrayList<Long>();
        }
        this.supplementalGroups.add(supplementalGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SupplementalGroups are the supplemental groups initially attached to the first process in the container")
    public List<Long> getSupplementalGroups() {
        return this.supplementalGroups;
    }

    public void setSupplementalGroups(@Nullable List<Long> supplementalGroups) {
        this.supplementalGroups = supplementalGroups;
    }

    public V1LinuxContainerUser uid(@Nonnull Long uid) {
        this.uid = uid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="UID is the primary uid initially attached to the first process in the container")
    public Long getUid() {
        return this.uid;
    }

    public void setUid(@Nonnull Long uid) {
        this.uid = uid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LinuxContainerUser v1LinuxContainerUser = (V1LinuxContainerUser)o;
        return Objects.equals(this.gid, v1LinuxContainerUser.gid) && Objects.equals(this.supplementalGroups, v1LinuxContainerUser.supplementalGroups) && Objects.equals(this.uid, v1LinuxContainerUser.uid);
    }

    public int hashCode() {
        return Objects.hash(this.gid, this.supplementalGroups, this.uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LinuxContainerUser {\n");
        sb.append("    gid: ").append(this.toIndentedString(this.gid)).append("\n");
        sb.append("    supplementalGroups: ").append(this.toIndentedString(this.supplementalGroups)).append("\n");
        sb.append("    uid: ").append(this.toIndentedString(this.uid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LinuxContainerUser is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LinuxContainerUser` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `supplementalGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS).toString()));
        }
    }

    public static V1LinuxContainerUser fromJson(String jsonString) throws IOException {
        return (V1LinuxContainerUser)JSON.getGson().fromJson(jsonString, V1LinuxContainerUser.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_GID);
        openapiFields.add(SERIALIZED_NAME_SUPPLEMENTAL_GROUPS);
        openapiFields.add(SERIALIZED_NAME_UID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_GID);
        openapiRequiredFields.add(SERIALIZED_NAME_UID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LinuxContainerUser.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LinuxContainerUser.class));
            return new TypeAdapter<V1LinuxContainerUser>(){

                public void write(JsonWriter out, V1LinuxContainerUser value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LinuxContainerUser read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1LinuxContainerUser.validateJsonElement(jsonElement);
                    return (V1LinuxContainerUser)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

