/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="Condition contains details for one aspect of the current state of this API Resource.")
public class V1Condition {
    public static final String SERIALIZED_NAME_LAST_TRANSITION_TIME = "lastTransitionTime";
    @SerializedName(value="lastTransitionTime")
    @Nonnull
    private OffsetDateTime lastTransitionTime;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    @Nonnull
    private String message;
    public static final String SERIALIZED_NAME_OBSERVED_GENERATION = "observedGeneration";
    @SerializedName(value="observedGeneration")
    @Nullable
    private Long observedGeneration;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    @Nonnull
    private String reason;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private String status;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1Condition lastTransitionTime(@Nonnull OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="lastTransitionTime is the last time the condition transitioned from one status to another. This should be when the underlying condition changed.  If that is not known, then using the time when the API field changed is acceptable.")
    public OffsetDateTime getLastTransitionTime() {
        return this.lastTransitionTime;
    }

    public void setLastTransitionTime(@Nonnull OffsetDateTime lastTransitionTime) {
        this.lastTransitionTime = lastTransitionTime;
    }

    public V1Condition message(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="message is a human readable message indicating details about the transition. This may be an empty string.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    public V1Condition observedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="observedGeneration represents the .metadata.generation that the condition was set based upon. For instance, if .metadata.generation is currently 12, but the .status.conditions[x].observedGeneration is 9, the condition is out of date with respect to the current state of the instance.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(@Nullable Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1Condition reason(@Nonnull String reason) {
        this.reason = reason;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="reason contains a programmatic identifier indicating the reason for the condition's last transition. Producers of specific condition types may define expected values and meanings for this field, and whether the values are considered a guaranteed API. The value should be a CamelCase string. This field may not be empty.")
    public String getReason() {
        return this.reason;
    }

    public void setReason(@Nonnull String reason) {
        this.reason = reason;
    }

    public V1Condition status(@Nonnull String status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="status of the condition, one of True, False, Unknown.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull String status) {
        this.status = status;
    }

    public V1Condition type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="type of condition in CamelCase or in foo.example.com/CamelCase.")
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Condition v1Condition = (V1Condition)o;
        return Objects.equals(this.lastTransitionTime, v1Condition.lastTransitionTime) && Objects.equals(this.message, v1Condition.message) && Objects.equals(this.observedGeneration, v1Condition.observedGeneration) && Objects.equals(this.reason, v1Condition.reason) && Objects.equals(this.status, v1Condition.status) && Objects.equals(this.type, v1Condition.type);
    }

    public int hashCode() {
        return Objects.hash(this.lastTransitionTime, this.message, this.observedGeneration, this.reason, this.status, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Condition {\n");
        sb.append("    lastTransitionTime: ").append(this.toIndentedString(this.lastTransitionTime)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1Condition is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1Condition` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MESSAGE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REASON).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reason` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REASON).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static V1Condition fromJson(String jsonString) throws IOException {
        return (V1Condition)JSON.getGson().fromJson(jsonString, V1Condition.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LAST_TRANSITION_TIME);
        openapiFields.add(SERIALIZED_NAME_MESSAGE);
        openapiFields.add(SERIALIZED_NAME_OBSERVED_GENERATION);
        openapiFields.add(SERIALIZED_NAME_REASON);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_TRANSITION_TIME);
        openapiRequiredFields.add(SERIALIZED_NAME_MESSAGE);
        openapiRequiredFields.add(SERIALIZED_NAME_REASON);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1Condition.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1Condition.class));
            return new TypeAdapter<V1Condition>(){

                public void write(JsonWriter out, V1Condition value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1Condition read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1Condition.validateJsonElement(jsonElement);
                    return (V1Condition)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

