/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1NetworkDeviceData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="AllocatedDeviceStatus contains the status of an allocated device, if the driver chooses to report it. This may include driver-specific information.  The combination of Driver, Pool, Device, and ShareID must match the corresponding key in Status.Allocation.Devices.")
public class V1AllocatedDeviceStatus {
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1Condition> conditions = new ArrayList<V1Condition>();
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    @Nullable
    private Object data;
    public static final String SERIALIZED_NAME_DEVICE = "device";
    @SerializedName(value="device")
    @Nonnull
    private String device;
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    @Nonnull
    private String driver;
    public static final String SERIALIZED_NAME_NETWORK_DATA = "networkData";
    @SerializedName(value="networkData")
    @Nullable
    private V1NetworkDeviceData networkData;
    public static final String SERIALIZED_NAME_POOL = "pool";
    @SerializedName(value="pool")
    @Nonnull
    private String pool;
    public static final String SERIALIZED_NAME_SHARE_I_D = "shareID";
    @SerializedName(value="shareID")
    @Nullable
    private String shareID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1AllocatedDeviceStatus conditions(@Nullable List<V1Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1AllocatedDeviceStatus addConditionsItem(V1Condition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1Condition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Conditions contains the latest observation of the device's state. If the device has been configured according to the class and claim config references, the `Ready` condition should be True.  Must not contain more than 8 entries.")
    public List<V1Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1Condition> conditions) {
        this.conditions = conditions;
    }

    public V1AllocatedDeviceStatus data(@Nullable Object data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Data contains arbitrary driver-specific data.  The length of the raw data must be smaller or equal to 10 Ki.")
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
    }

    public V1AllocatedDeviceStatus device(@Nonnull String device) {
        this.device = device;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Device references one device instance via its name in the driver's resource pool. It must be a DNS label.")
    public String getDevice() {
        return this.device;
    }

    public void setDevice(@Nonnull String device) {
        this.device = device;
    }

    public V1AllocatedDeviceStatus driver(@Nonnull String driver) {
        this.driver = driver;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Driver specifies the name of the DRA driver whose kubelet plugin should be invoked to process the allocation once the claim is needed on a node.  Must be a DNS subdomain and should end with a DNS domain owned by the vendor of the driver.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(@Nonnull String driver) {
        this.driver = driver;
    }

    public V1AllocatedDeviceStatus networkData(@Nullable V1NetworkDeviceData networkData) {
        this.networkData = networkData;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NetworkDeviceData getNetworkData() {
        return this.networkData;
    }

    public void setNetworkData(@Nullable V1NetworkDeviceData networkData) {
        this.networkData = networkData;
    }

    public V1AllocatedDeviceStatus pool(@Nonnull String pool) {
        this.pool = pool;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="This name together with the driver name and the device name field identify which device was allocated (`<driver name>/<pool name>/<device name>`).  Must not be longer than 253 characters and may contain one or more DNS sub-domains separated by slashes.")
    public String getPool() {
        return this.pool;
    }

    public void setPool(@Nonnull String pool) {
        this.pool = pool;
    }

    public V1AllocatedDeviceStatus shareID(@Nullable String shareID) {
        this.shareID = shareID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ShareID uniquely identifies an individual allocation share of the device.")
    public String getShareID() {
        return this.shareID;
    }

    public void setShareID(@Nullable String shareID) {
        this.shareID = shareID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1AllocatedDeviceStatus v1AllocatedDeviceStatus = (V1AllocatedDeviceStatus)o;
        return Objects.equals(this.conditions, v1AllocatedDeviceStatus.conditions) && Objects.equals(this.data, v1AllocatedDeviceStatus.data) && Objects.equals(this.device, v1AllocatedDeviceStatus.device) && Objects.equals(this.driver, v1AllocatedDeviceStatus.driver) && Objects.equals(this.networkData, v1AllocatedDeviceStatus.networkData) && Objects.equals(this.pool, v1AllocatedDeviceStatus.pool) && Objects.equals(this.shareID, v1AllocatedDeviceStatus.shareID);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.data, this.device, this.driver, this.networkData, this.pool, this.shareID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1AllocatedDeviceStatus {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    device: ").append(this.toIndentedString(this.device)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    networkData: ").append(this.toIndentedString(this.networkData)).append("\n");
        sb.append("    pool: ").append(this.toIndentedString(this.pool)).append("\n");
        sb.append("    shareID: ").append(this.toIndentedString(this.shareID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1AllocatedDeviceStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1AllocatedDeviceStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1Condition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_DEVICE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `device` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK_DATA) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK_DATA).isJsonNull()) {
            V1NetworkDeviceData.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETWORK_DATA));
        }
        if (!jsonObj.get(SERIALIZED_NAME_POOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pool` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SHARE_I_D) != null && !jsonObj.get(SERIALIZED_NAME_SHARE_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SHARE_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `shareID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SHARE_I_D).toString()));
        }
    }

    public static V1AllocatedDeviceStatus fromJson(String jsonString) throws IOException {
        return (V1AllocatedDeviceStatus)JSON.getGson().fromJson(jsonString, V1AllocatedDeviceStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_DATA);
        openapiFields.add(SERIALIZED_NAME_DEVICE);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_NETWORK_DATA);
        openapiFields.add(SERIALIZED_NAME_POOL);
        openapiFields.add(SERIALIZED_NAME_SHARE_I_D);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DEVICE);
        openapiRequiredFields.add(SERIALIZED_NAME_DRIVER);
        openapiRequiredFields.add(SERIALIZED_NAME_POOL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1AllocatedDeviceStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1AllocatedDeviceStatus.class));
            return new TypeAdapter<V1AllocatedDeviceStatus>(){

                public void write(JsonWriter out, V1AllocatedDeviceStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1AllocatedDeviceStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1AllocatedDeviceStatus.validateJsonElement(jsonElement);
                    return (V1AllocatedDeviceStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

