/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The node this Taint is attached to has the \"effect\" on any pod that does not tolerate the Taint.")
public class V1Taint {
    public static final String SERIALIZED_NAME_EFFECT = "effect";
    @SerializedName(value="effect")
    private EffectEnum effect;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    private String key;
    public static final String SERIALIZED_NAME_TIME_ADDED = "timeAdded";
    @SerializedName(value="timeAdded")
    private OffsetDateTime timeAdded;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;

    public V1Taint effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. The effect of the taint on pods that do not tolerate the taint. Valid effects are NoSchedule, PreferNoSchedule and NoExecute.  Possible enum values:  - `\"NoExecute\"` Evict any already-running pods that do not tolerate the taint. Currently enforced by NodeController.  - `\"NoSchedule\"` Do not allow new pods to schedule onto the node unless they tolerate the taint, but allow all pods submitted to Kubelet without going through the scheduler to start, and allow all already-running pods to continue running. Enforced by the scheduler.  - `\"PreferNoSchedule\"` Like TaintEffectNoSchedule, but the scheduler tries not to schedule new pods onto the node, rather than prohibiting new pods from scheduling onto the node entirely. Enforced by the scheduler.")
    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public V1Taint key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(required=true, value="Required. The taint key to be applied to a node.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public V1Taint timeAdded(OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TimeAdded represents the time at which the taint was added. It is only written for NoExecute taints.")
    public OffsetDateTime getTimeAdded() {
        return this.timeAdded;
    }

    public void setTimeAdded(OffsetDateTime timeAdded) {
        this.timeAdded = timeAdded;
    }

    public V1Taint value(String value) {
        this.value = value;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The taint value corresponding to the taint key.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Taint v1Taint = (V1Taint)o;
        return Objects.equals((Object)this.effect, (Object)v1Taint.effect) && Objects.equals(this.key, v1Taint.key) && Objects.equals(this.timeAdded, v1Taint.timeAdded) && Objects.equals(this.value, v1Taint.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.effect, this.key, this.timeAdded, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Taint {\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    timeAdded: ").append(this.toIndentedString(this.timeAdded)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EffectEnum {
        NOEXECUTE("NoExecute"),
        NOSCHEDULE("NoSchedule"),
        PREFERNOSCHEDULE("PreferNoSchedule");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EffectEnum fromValue(String value) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EffectEnum> {
            public void write(JsonWriter jsonWriter, EffectEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EffectEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EffectEnum.fromValue(value);
            }
        }
    }
}

