/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.openapi.models.V1HTTPHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="HTTPGetAction describes an action based on HTTP Get requests.")
public class V1HTTPGetAction {
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private String host;
    public static final String SERIALIZED_NAME_HTTP_HEADERS = "httpHeaders";
    @SerializedName(value="httpHeaders")
    private List<V1HTTPHeader> httpHeaders = null;
    public static final String SERIALIZED_NAME_PATH = "path";
    @SerializedName(value="path")
    private String path;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private IntOrString port;
    public static final String SERIALIZED_NAME_SCHEME = "scheme";
    @SerializedName(value="scheme")
    private SchemeEnum scheme;

    public V1HTTPGetAction host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public V1HTTPGetAction httpHeaders(List<V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public V1HTTPGetAction addHttpHeadersItem(V1HTTPHeader httpHeadersItem) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeader>();
        }
        this.httpHeaders.add(httpHeadersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom headers to set in the request. HTTP allows repeated headers.")
    public List<V1HTTPHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(List<V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public V1HTTPGetAction path(String path) {
        this.path = path;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Path to access on the HTTP server.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1HTTPGetAction port(IntOrString port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(IntOrString port) {
        this.port = port;
    }

    public V1HTTPGetAction scheme(SchemeEnum scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scheme to use for connecting to the host. Defaults to HTTP.  Possible enum values:  - `\"HTTP\"` means that the scheme used will be http://  - `\"HTTPS\"` means that the scheme used will be https://")
    public SchemeEnum getScheme() {
        return this.scheme;
    }

    public void setScheme(SchemeEnum scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPGetAction v1HTTPGetAction = (V1HTTPGetAction)o;
        return Objects.equals(this.host, v1HTTPGetAction.host) && Objects.equals(this.httpHeaders, v1HTTPGetAction.httpHeaders) && Objects.equals(this.path, v1HTTPGetAction.path) && Objects.equals(this.port, v1HTTPGetAction.port) && Objects.equals((Object)this.scheme, (Object)v1HTTPGetAction.scheme);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.host, this.httpHeaders, this.path, this.port, this.scheme});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HTTPGetAction {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    httpHeaders: ").append(this.toIndentedString(this.httpHeaders)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString((Object)this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SchemeEnum {
        HTTP("HTTP"),
        HTTPS("HTTPS");

        private String value;

        private SchemeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SchemeEnum fromValue(String value) {
            for (SchemeEnum b : SchemeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<SchemeEnum> {
            public void write(JsonWriter jsonWriter, SchemeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SchemeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SchemeEnum.fromValue(value);
            }
        }
    }
}

