/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.ServerKeyExchangeType;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.TLSExtension;
import io.ktor.network.tls.extensions.TLSExtensionType;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelOperationsKt;
import io.ktor.utils.io.core.BytePacketBuilderKt;
import io.ktor.utils.io.core.ByteReadPacketKt;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Sink;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0014\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0080@\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0006\u001a\u00020\u0005*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0013\u0010\t\u001a\u00020\b*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\t\u0010\n\u001a\u0013\u0010\f\u001a\u00020\u000b*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\f\u0010\r\u001a\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001b\u0010\u0015\u001a\u00020\u0014*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0014\u0010\u0018\u001a\u00020\u0017*\u00020\u0000H\u0082@\u00a2\u0006\u0004\b\u0018\u0010\u0003\u001a\u0013\u0010\u0018\u001a\u00020\u0017*\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0013\u0010\u001a\u001a\u00020\u0012*\u00020\u0004H\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001b\u001a\u0014\u0010\u001c\u001a\u00020\u0012*\u00020\u0000H\u0080@\u00a2\u0006\u0004\b\u001c\u0010\u0003\"\u0014\u0010\u001d\u001a\u00020\u00128\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lio/ktor/utils/io/ByteReadChannel;", "Lio/ktor/network/tls/TLSRecord;", "readTLSRecord", "(Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lkotlinx/io/Source;", "Lio/ktor/network/tls/TLSHandshake;", "readTLSHandshake", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/TLSHandshake;", "Lio/ktor/network/tls/TLSServerHello;", "readTLSServerHello", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/TLSServerHello;", "Lio/ktor/network/tls/extensions/NamedCurve;", "readCurveParams", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/extensions/NamedCurve;", "", "Ljava/security/cert/Certificate;", "readTLSCertificate", "(Lkotlinx/io/Source;)Ljava/util/List;", "", "fieldSize", "Ljava/security/spec/ECPoint;", "readECPoint", "(Lkotlinx/io/Source;I)Ljava/security/spec/ECPoint;", "Lio/ktor/network/tls/TLSVersion;", "readTLSVersion", "(Lkotlinx/io/Source;)Lio/ktor/network/tls/TLSVersion;", "readTripleByteLength", "(Lkotlinx/io/Source;)I", "readShortCompatible", "MAX_TLS_FRAME_SIZE", "I", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nio/ktor/network/tls/ParserKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n*L\n1#1,153:1\n21#2,3:154\n21#2,3:157\n*S KotlinDebug\n*F\n+ 1 Parser.kt\nio/ktor/network/tls/ParserKt\n*L\n33#1:154,3\n78#1:157,3\n*E\n"})
public final class ParserKt {
    private static final int MAX_TLS_FRAME_SIZE = 18432;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readTLSRecord(@NotNull ByteReadChannel $this$readTLSRecord, @NotNull Continuation<? super TLSRecord> $completion) {
        if (!($completion instanceof readTLSRecord.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readTLSRecord(null, (Continuation<? super TLSRecord>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_5 = TLSRecordType.Companion;
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = var6_5;
                $continuation.label = 1;
                v0 = ByteReadChannelOperationsKt.readByte((ByteReadChannel)$this$readTLSRecord, (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                var6_5 = (TLSRecordType.Companion)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                type = var6_5.byCode(((Number)v0).byteValue() & 255);
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.label = 2;
                v1 = ParserKt.readTLSVersion($this$readTLSRecord, (Continuation<? super TLSVersion>)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl38
            }
            case 2: {
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl38:
                // 2 sources

                version = (TLSVersion)v1;
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.L$2 = version;
                $continuation.label = 3;
                v2 = ParserKt.readShortCompatible($this$readTLSRecord, (Continuation<? super Integer>)$continuation);
                if (v2 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl53
            }
            case 3: {
                version = (TLSVersion)$continuation.L$2;
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl53:
                // 2 sources

                if ((length = ((Number)v2).intValue() & 65535) > 18432) {
                    throw new TLSException("Illegal TLS frame size: " + length, null, 2, null);
                }
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$readTLSRecord);
                $continuation.L$1 = type;
                $continuation.L$2 = version;
                $continuation.I$0 = length;
                $continuation.label = 4;
                v3 = ByteReadChannelOperationsKt.readPacket((ByteReadChannel)$this$readTLSRecord, (int)length, (Continuation)$continuation);
                if (v3 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl71
            }
            case 4: {
                length = $continuation.I$0;
                version = (TLSVersion)$continuation.L$2;
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl71:
                // 2 sources

                packet = (Source)v3;
                return new TLSRecord(type, version, packet);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TLSHandshake readTLSHandshake(@NotNull Source $this$readTLSHandshake) {
        void $this$readTLSHandshake_u24lambda_u240_u240;
        TLSHandshake tLSHandshake;
        Intrinsics.checkNotNullParameter((Object)$this$readTLSHandshake, (String)"<this>");
        TLSHandshake $this$readTLSHandshake_u24lambda_u240 = tLSHandshake = new TLSHandshake();
        boolean bl = false;
        int typeAndVersion = $this$readTLSHandshake.readInt();
        $this$readTLSHandshake_u24lambda_u240.setType(TLSHandshakeType.Companion.byCode(typeAndVersion >>> 24));
        int length = typeAndVersion & 0xFFFFFF;
        boolean $i$f$buildPacket = false;
        Buffer builder$iv = new Buffer();
        Sink sink = (Sink)builder$iv;
        TLSHandshake tLSHandshake2 = $this$readTLSHandshake_u24lambda_u240;
        boolean bl2 = false;
        BytePacketBuilderKt.writeFully$default((Sink)$this$readTLSHandshake_u24lambda_u240_u240, (byte[])SourcesKt.readByteArray((Source)$this$readTLSHandshake, (int)length), (int)0, (int)0, (int)6, null);
        tLSHandshake2.setPacket((Source)builder$iv);
        return tLSHandshake;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TLSServerHello readTLSServerHello(@NotNull Source $this$readTLSServerHello) {
        Intrinsics.checkNotNullParameter((Object)$this$readTLSServerHello, (String)"<this>");
        TLSVersion version = ParserKt.readTLSVersion($this$readTLSServerHello);
        byte[] random = new byte[32];
        ByteReadPacketKt.readFully$default((Source)$this$readTLSServerHello, (byte[])random, (int)0, (int)0, (int)6, null);
        int sessionIdLength = $this$readTLSServerHello.readByte() & 0xFF;
        if (sessionIdLength > 32) {
            throw new TLSException("sessionId length limit of 32 bytes exceeded: " + sessionIdLength + " specified", null, 2, null);
        }
        byte[] sessionId = new byte[32];
        ByteReadPacketKt.readFully((Source)$this$readTLSServerHello, (byte[])sessionId, (int)0, (int)sessionIdLength);
        short suite = $this$readTLSServerHello.readShort();
        short compressionMethod = (short)((short)$this$readTLSServerHello.readByte() & 0xFF);
        if (compressionMethod != 0) {
            throw new TLSException("Unsupported TLS compression method " + compressionMethod + " (only null 0 compression method is supported)", null, 2, null);
        }
        if ((int)ByteReadPacketKt.getRemaining((Source)$this$readTLSServerHello) == 0) {
            return new TLSServerHello(version, random, sessionId, suite, compressionMethod, null, 32, null);
        }
        int extensionSize = $this$readTLSServerHello.readShort() & 0xFFFF;
        if ((int)ByteReadPacketKt.getRemaining((Source)$this$readTLSServerHello) != extensionSize) {
            throw new TLSException("Invalid extensions size: requested " + extensionSize + ", available " + ByteReadPacketKt.getRemaining((Source)$this$readTLSServerHello), null, 2, null);
        }
        List extensions = new ArrayList();
        while (ByteReadPacketKt.getRemaining((Source)$this$readTLSServerHello) > 0L) {
            void $this$readTLSServerHello_u24lambda_u240;
            int type = $this$readTLSServerHello.readShort() & 0xFFFF;
            int length = $this$readTLSServerHello.readShort() & 0xFFFF;
            Collection collection = extensions;
            boolean $i$f$buildPacket = false;
            Buffer builder$iv = new Buffer();
            Sink sink = (Sink)builder$iv;
            int n = length;
            TLSExtensionType tLSExtensionType = TLSExtensionType.Companion.byCode(type);
            boolean bl = false;
            BytePacketBuilderKt.writeFully$default((Sink)$this$readTLSServerHello_u24lambda_u240, (byte[])SourcesKt.readByteArray((Source)$this$readTLSServerHello, (int)length), (int)0, (int)0, (int)6, null);
            Unit unit = Unit.INSTANCE;
            Source source = (Source)builder$iv;
            int n2 = n;
            TLSExtensionType tLSExtensionType2 = tLSExtensionType;
            collection.add(new TLSExtension(tLSExtensionType2, n2, source));
        }
        return new TLSServerHello(version, random, sessionId, suite, compressionMethod, extensions);
    }

    @NotNull
    public static final NamedCurve readCurveParams(@NotNull Source $this$readCurveParams) {
        Intrinsics.checkNotNullParameter((Object)$this$readCurveParams, (String)"<this>");
        int type = $this$readCurveParams.readByte() & 0xFF;
        switch (WhenMappings.$EnumSwitchMapping$0[ServerKeyExchangeType.Companion.byCode(type).ordinal()]) {
            case 1: {
                short curveId = $this$readCurveParams.readShort();
                NamedCurve namedCurve = NamedCurve.Companion.fromCode(curveId);
                if (namedCurve == null) {
                    throw new TLSException("Unknown EC id", null, 2, null);
                }
                return namedCurve;
            }
            case 2: {
                throw new IllegalStateException("ExplicitPrime server key exchange type is not yet supported".toString());
            }
            case 3: {
                throw new IllegalStateException("ExplicitChar server key exchange type is not yet supported".toString());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final List<Certificate> readTLSCertificate(@NotNull Source $this$readTLSCertificate) {
        int certificateLength;
        Intrinsics.checkNotNullParameter((Object)$this$readTLSCertificate, (String)"<this>");
        int certificatesChainLength = ParserKt.readTripleByteLength($this$readTLSCertificate);
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Intrinsics.checkNotNull((Object)certificateFactory);
        CertificateFactory factory = certificateFactory;
        for (int certificateBase = 0; certificateBase < certificatesChainLength; certificateBase += certificateLength + 3) {
            certificateLength = ParserKt.readTripleByteLength($this$readTLSCertificate);
            if (certificateLength > certificatesChainLength - certificateBase) {
                throw new TLSException("Certificate length is too big", null, 2, null);
            }
            if ((long)certificateLength > ByteReadPacketKt.getRemaining((Source)$this$readTLSCertificate)) {
                throw new TLSException("Certificate length is too big", null, 2, null);
            }
            byte[] certificate = new byte[certificateLength];
            ByteReadPacketKt.readFully$default((Source)$this$readTLSCertificate, (byte[])certificate, (int)0, (int)0, (int)6, null);
            Certificate x509 = factory.generateCertificate(new ByteArrayInputStream(certificate));
            result.add(x509);
        }
        return result;
    }

    @NotNull
    public static final ECPoint readECPoint(@NotNull Source $this$readECPoint, int fieldSize) {
        Intrinsics.checkNotNullParameter((Object)$this$readECPoint, (String)"<this>");
        int pointSize = $this$readECPoint.readByte() & 0xFF;
        byte tag = $this$readECPoint.readByte();
        if (tag != 4) {
            throw new TLSException("Point should be uncompressed", null, 2, null);
        }
        int componentLength = (pointSize - 1) / 2;
        if (fieldSize + 7 >>> 3 != componentLength) {
            throw new TLSException("Invalid point component length", null, 2, null);
        }
        return new ECPoint(new BigInteger(1, SourcesKt.readByteArray((Source)$this$readECPoint, (int)componentLength)), new BigInteger(1, SourcesKt.readByteArray((Source)$this$readECPoint, (int)componentLength)));
    }

    /*
     * Unable to fully structure code
     */
    private static final Object readTLSVersion(ByteReadChannel $this$readTLSVersion, Continuation<? super TLSVersion> $completion) {
        if (!($completion instanceof readTLSVersion.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.access$readTLSVersion(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = TLSVersion.Companion;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$readTLSVersion);
                $continuation.L$1 = var2_5;
                $continuation.label = 1;
                v0 = ParserKt.readShortCompatible($this$readTLSVersion, (Continuation<? super Integer>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                var2_5 = (TLSVersion.Companion)$continuation.L$1;
                $this$readTLSVersion = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                return var2_5.byCode(((Number)v0).intValue() & 65535);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final TLSVersion readTLSVersion(Source $this$readTLSVersion) {
        return TLSVersion.Companion.byCode($this$readTLSVersion.readShort() & 0xFFFF);
    }

    public static final int readTripleByteLength(@NotNull Source $this$readTripleByteLength) {
        Intrinsics.checkNotNullParameter((Object)$this$readTripleByteLength, (String)"<this>");
        return ($this$readTripleByteLength.readByte() & 0xFF) << 16 | $this$readTripleByteLength.readShort() & 0xFFFF;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readShortCompatible(@NotNull ByteReadChannel $this$readShortCompatible, @NotNull Continuation<? super Integer> $completion) {
        if (!($completion instanceof readShortCompatible.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readShortCompatible(null, (Continuation<? super Integer>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = $this$readShortCompatible;
                $continuation.label = 1;
                v0 = ByteReadChannelOperationsKt.readByte((ByteReadChannel)$this$readShortCompatible, (Continuation)$continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this$readShortCompatible = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                first = ((Number)v0).byteValue() & 255;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$readShortCompatible);
                $continuation.I$0 = first;
                $continuation.label = 2;
                v1 = ByteReadChannelOperationsKt.readByte((ByteReadChannel)$this$readShortCompatible, (Continuation)$continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                first = $continuation.I$0;
                $this$readShortCompatible = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                second = ((Number)v1).byteValue() & 255;
                return Boxing.boxInt((int)((first << 8) + second));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$readTLSVersion(ByteReadChannel $receiver, Continuation $completion) {
        return ParserKt.readTLSVersion($receiver, (Continuation<? super TLSVersion>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ServerKeyExchangeType.values().length];
            try {
                nArray[ServerKeyExchangeType.NamedCurve.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerKeyExchangeType.ExplicitPrime.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerKeyExchangeType.ExplicitChar.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

