/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.extensions.spring;

import io.kotest.core.Logger;
import io.kotest.core.test.TestCase;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.FixedValue;
import net.bytebuddy.implementation.Implementation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/kotest/extensions/spring/SpringJavaCompatibility;", "", "<init>", "()V", "logger", "Lio/kotest/core/Logger;", "ignoreSpringListenerOnFinalClassWarning", "", "getIgnoreSpringListenerOnFinalClassWarning", "()Z", "setIgnoreSpringListenerOnFinalClassWarning", "(Z)V", "methodHandle", "Ljava/lang/reflect/Method;", "testCase", "Lio/kotest/core/test/TestCase;", "checkForSafeClassName", "", "kclass", "Lkotlin/reflect/KClass;", "methodName", "", "illegals", "", "methodNameRegex", "Lkotlin/text/Regex;", "ignoreFinalWarning", "kotest-extensions-spring"})
@SourceDebugExtension(value={"SMAP\nSpringJavaCompatibility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringJavaCompatibility.kt\nio/kotest/extensions/spring/SpringJavaCompatibility\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1310#2,2:78\n11228#2:80\n11563#2,3:81\n1761#3,3:84\n*S KotlinDebug\n*F\n+ 1 SpringJavaCompatibility.kt\nio/kotest/extensions/spring/SpringJavaCompatibility\n*L\n33#1:78,2\n34#1:80\n34#1:81,3\n54#1:84,3\n*E\n"})
public final class SpringJavaCompatibility {
    @NotNull
    public static final SpringJavaCompatibility INSTANCE = new SpringJavaCompatibility();
    @NotNull
    private static final Logger logger = new Logger(Reflection.getOrCreateKotlinClass(SpringJavaCompatibility.class));
    private static boolean ignoreSpringListenerOnFinalClassWarning;
    @NotNull
    private static final List<String> illegals;
    @NotNull
    private static final Regex methodNameRegex;
    private static final boolean ignoreFinalWarning;

    private SpringJavaCompatibility() {
    }

    public final boolean getIgnoreSpringListenerOnFinalClassWarning() {
        return ignoreSpringListenerOnFinalClassWarning;
    }

    public final void setIgnoreSpringListenerOnFinalClassWarning(boolean bl) {
        ignoreSpringListenerOnFinalClassWarning = bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Method methodHandle(@NotNull TestCase testCase) {
        Method method;
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        if (Modifier.isFinal(testCase.getSpec().getClass().getModifiers())) {
            Method method2;
            Method[] methods;
            block6: {
                if (!ignoreFinalWarning) {
                    System.out.println((Object)"Using SpringListener on a final class. If any Spring annotation fails to work, try making this class open.");
                }
                methods = this.getClass().getMethods();
                Intrinsics.checkNotNull((Object)methods);
                Method[] $this$firstOrNull$iv = methods;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    Method element$iv;
                    Method it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"methodHandle")) continue;
                    method2 = element$iv;
                    break block6;
                }
                method2 = method = null;
            }
            if (method2 == null) {
                void $this$mapTo$iv$iv;
                Object $this$map$iv = methods;
                boolean $i$f$map = false;
                Method[] methodArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((Method[])$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var12_18 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getName());
                }
                $this$map$iv = "Could not find a method to attach spring lifecycle methods to: " + (List)destination$iv$iv;
                throw new IllegalStateException($this$map$iv.toString());
            }
        } else {
            String methodName = this.methodName(testCase);
            ModifierContributor.ForMethod[] forMethodArray = new ModifierContributor.ForMethod[]{Visibility.PUBLIC};
            Class fakeSpec = new ByteBuddy().subclass(testCase.getSpec().getClass()).defineMethod(methodName, (Type)((Object)String.class), forMethodArray).intercept((Implementation)FixedValue.value((Object)"Foo")).make().load(this.getClass().getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.CHILD_FIRST).getLoaded();
            Method method3 = fakeSpec.getMethod(methodName, new Class[0]);
            Intrinsics.checkNotNull((Object)method3);
            method = method3;
        }
        return method;
    }

    public final void checkForSafeClassName(@NotNull KClass<?> kclass) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(kclass, (String)"kclass");
            logger.log(() -> SpringJavaCompatibility.checkForSafeClassName$lambda$2(kclass));
            String string = JvmClassMappingKt.getJavaClass(kclass).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            char[] cArray = new char[]{'.'};
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!illegals.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalStateException(("Spec package name cannot contain a java keyword: " + CollectionsKt.joinToString$default((Iterable)illegals, (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).toString());
        }
    }

    @NotNull
    public final String methodName(@NotNull TestCase testCase) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        CharSequence charSequence = testCase.getName().getName() + "_" + UUID.randomUUID();
        Regex regex = methodNameRegex;
        String string = "_";
        String it = regex.replace(charSequence, string);
        boolean bl = false;
        return Character.isLetter(StringsKt.first((CharSequence)it)) ? it : "_" + it;
    }

    private static final Pair checkForSafeClassName$lambda$2(KClass $kclass) {
        return new Pair((Object)$kclass.getSimpleName(), (Object)"Checking for spring safe class name");
    }

    static {
        Object[] objectArray = new String[]{"import", "finally", "catch", "const", "final", "inner", "protected", "private", "public"};
        illegals = CollectionsKt.listOf((Object[])objectArray);
        methodNameRegex = new Regex("[^a-zA-Z_0-9]");
        ignoreFinalWarning = ignoreSpringListenerOnFinalClassWarning || !Boolean.parseBoolean(System.getProperty("kotest.listener.spring.ignore.warning", "false"));
    }
}

