/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.string;

import io.kotest.assertions.AssertionErrorBuilder;
import io.kotest.assertions.print.PrintKt;
import io.kotest.assertions.print.StringPrint;
import io.kotest.assertions.submatching.StringPartialMatchesKt;
import io.kotest.matchers.ComparisonMatcherResult;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.NeverNullMatcherKt;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.string.ContainInOrderOutcome;
import io.kotest.matchers.string.MatchersKt;
import io.kotest.matchers.string.UUIDVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u000e\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0006\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u0019\u0010\b\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\n\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u000e\u0010\r\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001\u001a\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u000e\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u001a\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0086\u0004\u001a\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\u0018\u001a\u00020\u0019\u001a'\u0010\u001c\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001f\u001a'\u0010 \u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\u001f\u001a'\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001\u00a2\u0006\u0002\u0010\"\u001a\u0018\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020\u0001H\u0000\u001a)\u0010&\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u00012\u0012\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001e\"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u001f\u001a(\u0010)\u001a\u00020*2\u0006\u0010$\u001a\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010+2\b\b\u0002\u0010,\u001a\u00020-H\u0000\u001a\u0019\u0010\u0017\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0019\u0010.\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u0010/\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0016\u00101\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u0010\t\u001a\u00020\u0001\u001a\u0019\u00102\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u0001H\u0086\u0004\u001a\u0019\u00104\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00012\u0006\u00103\u001a\u00020\u0001H\u0086\u0004\u001a\u0016\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00042\u0006\u00103\u001a\u00020\u0001\u001a\u001e\u00106\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u00107\u001a\u0002082\b\b\u0002\u00109\u001a\u00020:\u001a\u001e\u0010;\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u00107\u001a\u0002082\b\b\u0002\u00109\u001a\u00020:\u001a \u0010<\u001a\b\u0012\u0004\u0012\u00020\u00010\u00042\b\b\u0002\u00107\u001a\u0002082\b\b\u0002\u00109\u001a\u00020:\u001a#\u0010=\u001a\u00020-*\u0004\u0018\u00010\u00012\b\b\u0002\u0010>\u001a\u00020-\u0082\u0002\n\n\b\b\u0000\u001a\u0004\b\u0003\u0010\u0000\u00a8\u0006?"}, d2={"shouldContainOnlyDigits", "", "shouldNotContainOnlyDigits", "containOnlyDigits", "Lio/kotest/matchers/Matcher;", "shouldContainADigit", "shouldNotContainADigit", "containADigit", "shouldContainOnlyOnce", "substr", "shouldNotContainOnlyOnce", "containOnlyOnce", "substring", "shouldBeEmpty", "shouldNotBeEmpty", "beEmpty", "shouldBeBlank", "shouldNotBeBlank", "containOnlyWhitespace", "beBlank", "shouldContainIgnoringCase", "shouldNotContainIgnoringCase", "containIgnoringCase", "shouldContain", "regex", "Lkotlin/text/Regex;", "shouldNotContain", "contain", "shouldContainInOrder", "substrings", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "shouldNotContainInOrder", "containInOrder", "([Ljava/lang/String;)Lio/kotest/matchers/Matcher;", "prefixIfNotEmpty", "value", "prefix", "joinNonEmpty", "separator", "values", "matchSubstrings", "Lio/kotest/matchers/string/ContainInOrderOutcome;", "", "depth", "", "shouldInclude", "shouldNotInclude", "haveSubstring", "include", "shouldBeEqualIgnoringCase", "other", "shouldNotBeEqualIgnoringCase", "beEqualIgnoringCase", "shouldBeUUID", "version", "Lio/kotest/matchers/string/UUIDVersion;", "considerNilValid", "", "shouldNotBeUUID", "beUUID", "shouldBeInteger", "radix", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nmatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchers.kt\nio/kotest/matchers/string/MatchersKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,429:1\n3919#2:430\n4434#2,2:431\n295#3,2:433\n774#3:444\n865#3,2:445\n1#4:435\n209#5,8:436\n*S KotlinDebug\n*F\n+ 1 matchers.kt\nio/kotest/matchers/string/MatchersKt\n*L\n192#1:430\n192#1:431,2\n28#1:433,2\n256#1:444\n256#1:445,2\n46#1:436,8\n*E\n"})
public final class MatchersKt {
    @Nullable
    public static final String shouldContainOnlyDigits(@Nullable String $this$shouldContainOnlyDigits) {
        ShouldKt.should($this$shouldContainOnlyDigits, MatchersKt.containOnlyDigits());
        return $this$shouldContainOnlyDigits;
    }

    @Nullable
    public static final String shouldNotContainOnlyDigits(@Nullable String $this$shouldNotContainOnlyDigits) {
        ShouldKt.shouldNot($this$shouldNotContainOnlyDigits, MatchersKt.containOnlyDigits());
        return $this$shouldNotContainOnlyDigits;
    }

    @NotNull
    public static final Matcher<String> containOnlyDigits() {
        return NeverNullMatcherKt.neverNullMatcher(MatchersKt::containOnlyDigits$lambda$0);
    }

    @Nullable
    public static final String shouldContainADigit(@Nullable String $this$shouldContainADigit) {
        ShouldKt.should($this$shouldContainADigit, MatchersKt.containADigit());
        return $this$shouldContainADigit;
    }

    @Nullable
    public static final String shouldNotContainADigit(@Nullable String $this$shouldNotContainADigit) {
        ShouldKt.shouldNot($this$shouldNotContainADigit, MatchersKt.containADigit());
        return $this$shouldNotContainADigit;
    }

    @NotNull
    public static final Matcher<String> containADigit() {
        return NeverNullMatcherKt.neverNullMatcher(MatchersKt::containADigit$lambda$0);
    }

    @Nullable
    public static final String shouldContainOnlyOnce(@Nullable String $this$shouldContainOnlyOnce, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should($this$shouldContainOnlyOnce, MatchersKt.containOnlyOnce(substr));
        return $this$shouldContainOnlyOnce;
    }

    @Nullable
    public static final String shouldNotContainOnlyOnce(@Nullable String $this$shouldNotContainOnlyOnce, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot($this$shouldNotContainOnlyOnce, MatchersKt.containOnlyOnce(substr));
        return $this$shouldNotContainOnlyOnce;
    }

    @NotNull
    public static final Matcher<String> containOnlyOnce(@NotNull String substring) {
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        return NeverNullMatcherKt.neverNullMatcher(arg_0 -> MatchersKt.containOnlyOnce$lambda$0(substring, arg_0));
    }

    @Nullable
    public static final String shouldBeEmpty(@Nullable String $this$shouldBeEmpty) {
        ShouldKt.should($this$shouldBeEmpty, MatchersKt.beEmpty());
        return $this$shouldBeEmpty;
    }

    @Nullable
    public static final String shouldNotBeEmpty(@Nullable String $this$shouldNotBeEmpty) {
        ShouldKt.shouldNot($this$shouldNotBeEmpty, MatchersKt.beEmpty());
        return $this$shouldNotBeEmpty;
    }

    @NotNull
    public static final Matcher<String> beEmpty() {
        return NeverNullMatcherKt.neverNullMatcher(MatchersKt::beEmpty$lambda$0);
    }

    @Nullable
    public static final String shouldBeBlank(@Nullable String $this$shouldBeBlank) {
        ShouldKt.should($this$shouldBeBlank, MatchersKt.beBlank());
        return $this$shouldBeBlank;
    }

    @Nullable
    public static final String shouldNotBeBlank(@Nullable String $this$shouldNotBeBlank) {
        ShouldKt.shouldNot($this$shouldNotBeBlank, MatchersKt.beBlank());
        return $this$shouldNotBeBlank;
    }

    @NotNull
    public static final Matcher<String> containOnlyWhitespace() {
        return MatchersKt.beBlank();
    }

    @NotNull
    public static final Matcher<String> beBlank() {
        return NeverNullMatcherKt.neverNullMatcher(MatchersKt::beBlank$lambda$0);
    }

    @Nullable
    public static final String shouldContainIgnoringCase(@Nullable String $this$shouldContainIgnoringCase, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should($this$shouldContainIgnoringCase, MatchersKt.containIgnoringCase(substr));
        return $this$shouldContainIgnoringCase;
    }

    @Nullable
    public static final String shouldNotContainIgnoringCase(@Nullable String $this$shouldNotContainIgnoringCase, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot($this$shouldNotContainIgnoringCase, MatchersKt.containIgnoringCase(substr));
        return $this$shouldNotContainIgnoringCase;
    }

    @NotNull
    public static final Matcher<String> containIgnoringCase(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return NeverNullMatcherKt.neverNullMatcher(arg_0 -> MatchersKt.containIgnoringCase$lambda$0(substr, arg_0));
    }

    @Nullable
    public static final String shouldContain(@Nullable String $this$shouldContain, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        ShouldKt.should($this$shouldContain, MatchersKt.contain(regex));
        return $this$shouldContain;
    }

    @Nullable
    public static final String shouldNotContain(@Nullable String $this$shouldNotContain, @NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        ShouldKt.shouldNot($this$shouldNotContain, MatchersKt.contain(regex));
        return $this$shouldNotContain;
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        return NeverNullMatcherKt.neverNullMatcher(arg_0 -> MatchersKt.contain$lambda$0(regex, arg_0));
    }

    @Nullable
    public static final String shouldContainInOrder(@Nullable String $this$shouldContainInOrder, String ... substrings) {
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        ShouldKt.should($this$shouldContainInOrder, MatchersKt.containInOrder(Arrays.copyOf(substrings, substrings.length)));
        return $this$shouldContainInOrder;
    }

    @Nullable
    public static final String shouldNotContainInOrder(@Nullable String $this$shouldNotContainInOrder, String ... substrings) {
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        ShouldKt.shouldNot($this$shouldNotContainInOrder, MatchersKt.containInOrder(Arrays.copyOf(substrings, substrings.length)));
        return $this$shouldNotContainInOrder;
    }

    @NotNull
    public static final Matcher<String> containInOrder(String ... substrings) {
        Intrinsics.checkNotNullParameter((Object)substrings, (String)"substrings");
        return NeverNullMatcherKt.neverNullMatcher(arg_0 -> MatchersKt.containInOrder$lambda$0(substrings, arg_0));
    }

    @NotNull
    public static final String prefixIfNotEmpty(@NotNull String value, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return ((CharSequence)value).length() == 0 ? "" : prefix + value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String joinNonEmpty(@NotNull String separator, String ... values) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        String[] $this$filter$iv = values;
        boolean $i$f$filter = false;
        String[] stringArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final ContainInOrderOutcome matchSubstrings(@NotNull String value, @NotNull List<String> substrings, int depth) {
        ContainInOrderOutcome containInOrderOutcome;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(substrings, (String)"substrings");
        if (substrings.isEmpty()) {
            containInOrderOutcome = ContainInOrderOutcome.Match.INSTANCE;
        } else {
            String currentSubstring = substrings.get(0);
            int matchAtIndex = StringsKt.indexOf$default((CharSequence)value, (String)currentSubstring, (int)0, (boolean)false, (int)6, null);
            if (matchAtIndex == -1) {
                containInOrderOutcome = new ContainInOrderOutcome.Mismatch(currentSubstring, depth);
            } else if (Intrinsics.areEqual((Object)currentSubstring, (Object)"")) {
                containInOrderOutcome = MatchersKt.matchSubstrings(value, CollectionsKt.drop((Iterable)substrings, (int)1), depth + 1);
            } else {
                String string = value.substring(matchAtIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                containInOrderOutcome = MatchersKt.matchSubstrings(string, CollectionsKt.drop((Iterable)substrings, (int)1), depth + 1);
            }
        }
        return containInOrderOutcome;
    }

    public static /* synthetic */ ContainInOrderOutcome matchSubstrings$default(String string, List list, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return MatchersKt.matchSubstrings(string, list, n);
    }

    @Nullable
    public static final String shouldContain(@Nullable String $this$shouldContain, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should($this$shouldContain, MatchersKt.contain(substr));
        return $this$shouldContain;
    }

    @Nullable
    public static final String shouldNotContain(@Nullable String $this$shouldNotContain, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot($this$shouldNotContain, MatchersKt.contain(substr));
        return $this$shouldNotContain;
    }

    @NotNull
    public static final Matcher<String> contain(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return MatchersKt.include(substr);
    }

    @Nullable
    public static final String shouldInclude(@Nullable String $this$shouldInclude, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.should($this$shouldInclude, MatchersKt.include(substr));
        return $this$shouldInclude;
    }

    @Nullable
    public static final String shouldNotInclude(@Nullable String $this$shouldNotInclude, @NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        ShouldKt.shouldNot($this$shouldNotInclude, MatchersKt.include(substr));
        return $this$shouldNotInclude;
    }

    @NotNull
    public static final Matcher<String> haveSubstring(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return MatchersKt.include(substr);
    }

    @NotNull
    public static final Matcher<String> include(@NotNull String substr) {
        Intrinsics.checkNotNullParameter((Object)substr, (String)"substr");
        return NeverNullMatcherKt.neverNullMatcher(arg_0 -> MatchersKt.include$lambda$0(substr, arg_0));
    }

    @Nullable
    public static final String shouldBeEqualIgnoringCase(@Nullable String $this$shouldBeEqualIgnoringCase, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should($this$shouldBeEqualIgnoringCase, MatchersKt.beEqualIgnoringCase(other));
        return $this$shouldBeEqualIgnoringCase;
    }

    @Nullable
    public static final String shouldNotBeEqualIgnoringCase(@Nullable String $this$shouldNotBeEqualIgnoringCase, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot($this$shouldNotBeEqualIgnoringCase, MatchersKt.beEqualIgnoringCase(other));
        return $this$shouldNotBeEqualIgnoringCase;
    }

    @NotNull
    public static final Matcher<String> beEqualIgnoringCase(@NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return NeverNullMatcherKt.neverNullMatcher(arg_0 -> MatchersKt.beEqualIgnoringCase$lambda$0(other, arg_0));
    }

    @NotNull
    public static final String shouldBeUUID(@NotNull String $this$shouldBeUUID, @NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        ShouldKt.should($this$shouldBeUUID, MatchersKt.beUUID(version, considerNilValid));
        return $this$shouldBeUUID;
    }

    public static /* synthetic */ String shouldBeUUID$default(String string, UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.shouldBeUUID(string, uUIDVersion, bl);
    }

    @NotNull
    public static final String shouldNotBeUUID(@NotNull String $this$shouldNotBeUUID, @NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeUUID, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        ShouldKt.shouldNot($this$shouldNotBeUUID, MatchersKt.beUUID(version, considerNilValid));
        return $this$shouldNotBeUUID;
    }

    public static /* synthetic */ String shouldNotBeUUID$default(String string, UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.shouldNotBeUUID(string, uUIDVersion, bl);
    }

    @NotNull
    public static final Matcher<String> beUUID(@NotNull UUIDVersion version, boolean considerNilValid) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        return (Matcher)new Matcher<String>(version, considerNilValid){
            final /* synthetic */ UUIDVersion $version;
            final /* synthetic */ boolean $considerNilValid;
            {
                this.$version = $version;
                this.$considerNilValid = $considerNilValid;
            }

            public MatcherResult test(String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                CharSequence charSequence = value;
                return MatcherResult.Companion.invoke(this.$version.getUuidRegex().matches(charSequence) || this.$considerNilValid && this.isNilUUID(value), () -> beUUID.1.test$lambda$0(value, this.$version), () -> beUUID.1.test$lambda$1(value, this.$version));
            }

            private final boolean isNilUUID(String $this$isNilUUID) {
                return Intrinsics.areEqual((Object)$this$isNilUUID, (Object)"00000000-0000-0000-0000-000000000000");
            }

            private static final String test$lambda$0(String $value, UUIDVersion $version) {
                return "String " + $value + " is not an UUID (" + $version + "), but should be";
            }

            private static final String test$lambda$1(String $value, UUIDVersion $version) {
                return "String " + $value + " is an UUID (" + $version + "), but shouldn't be";
            }
        };
    }

    public static /* synthetic */ Matcher beUUID$default(UUIDVersion uUIDVersion, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUIDVersion = UUIDVersion.ANY;
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return MatchersKt.beUUID(uUIDVersion, bl);
    }

    public static final int shouldBeInteger(@Nullable String $this$shouldBeInteger, int radix) {
        if ($this$shouldBeInteger == null) {
            AssertionErrorBuilder.Companion.fail("String is null, but it should be integer.");
            throw new KotlinNothingValueException();
        }
        Integer integer = StringsKt.toIntOrNull((String)$this$shouldBeInteger, (int)radix);
        if (integer == null) {
            AssertionErrorBuilder.Companion.fail("String '" + $this$shouldBeInteger + "' is not integer, but it should be.");
            throw new KotlinNothingValueException();
        }
        return integer;
    }

    public static /* synthetic */ int shouldBeInteger$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        return MatchersKt.shouldBeInteger(string, n);
    }

    private static final MatcherResult containOnlyDigits$lambda$0(String value) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            char[] cArray = value.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
            Iterable $this$firstOrNull$iv = ArraysKt.withIndex((char[])cArray);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IndexedValue it = (IndexedValue)element$iv;
                boolean bl = false;
                char c = ((Character)it.getValue()).charValue();
                boolean bl2 = '0' <= c ? c < ':' : false;
                if (!(!bl2)) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        IndexedValue firstNonDigit = v2;
        return MatcherResult.Companion.invoke(firstNonDigit == null, () -> MatchersKt.containOnlyDigits$lambda$0$1(value, firstNonDigit), () -> MatchersKt.containOnlyDigits$lambda$0$2(value));
    }

    /*
     * WARNING - void declaration
     */
    private static final String containOnlyDigits$lambda$0$1(String $value, IndexedValue $firstNonDigit) {
        String string;
        String string2 = PrintKt.print($value).getValue();
        IndexedValue indexedValue = $firstNonDigit;
        if (indexedValue != null) {
            void it;
            IndexedValue indexedValue2 = indexedValue;
            String string3 = string2;
            boolean bl = false;
            string = PrintKt.print(it.getValue()).getValue();
            string2 = string3;
        } else {
            string = null;
        }
        IndexedValue indexedValue3 = $firstNonDigit;
        return string2 + " should contain only digits, but contained " + string + " at index " + (indexedValue3 != null ? Integer.valueOf(indexedValue3.getIndex()) : null);
    }

    private static final String containOnlyDigits$lambda$0$2(String $value) {
        return PrintKt.print($value).getValue() + " should not contain only digits";
    }

    private static final MatcherResult containADigit$lambda$0(String value) {
        int n;
        block3: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Sequence $this$indexOfFirst$iv = StringsKt.asSequence((CharSequence)value);
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv : $this$indexOfFirst$iv) {
                if (index$iv < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                char it = ((Character)item$iv).charValue();
                boolean bl = false;
                boolean bl2 = '0' <= it ? it < ':' : false;
                if (bl2) {
                    n = index$iv;
                    break block3;
                }
                ++index$iv;
            }
            n = -1;
        }
        int indexOfFirstDigit = n;
        String possibleFirstDigitMessage = indexOfFirstDigit > -1 ? ", but contained " + PrintKt.print(StringsKt.getOrNull((CharSequence)value, (int)indexOfFirstDigit)).getValue() + " at index " + indexOfFirstDigit : "";
        return MatcherResult.Companion.invoke(indexOfFirstDigit > -1, () -> MatchersKt.containADigit$lambda$0$1(value), () -> MatchersKt.containADigit$lambda$0$2(value, possibleFirstDigitMessage));
    }

    private static final String containADigit$lambda$0$1(String $value) {
        return PrintKt.print($value).getValue() + " should contain at least one digit";
    }

    private static final String containADigit$lambda$0$2(String $value, String $possibleFirstDigitMessage) {
        return PrintKt.print($value).getValue() + " should not contain any digits" + $possibleFirstDigitMessage;
    }

    private static final MatcherResult containOnlyOnce$lambda$0(String $substring, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int firstIndexOf = StringsKt.indexOf$default((CharSequence)value, (String)$substring, (int)0, (boolean)false, (int)6, null);
        int lastIndexOf = StringsKt.lastIndexOf$default((CharSequence)value, (String)$substring, (int)0, (boolean)false, (int)6, null);
        boolean passed = firstIndexOf >= 0 && firstIndexOf == lastIndexOf;
        String failureDescription = passed ? "" : (firstIndexOf == -1 ? ", but did not contain it" : ", but contained it at least at indexes " + firstIndexOf + " and " + lastIndexOf);
        return MatcherResult.Companion.invoke(passed, () -> MatchersKt.containOnlyOnce$lambda$0$0(value, $substring, failureDescription), () -> MatchersKt.containOnlyOnce$lambda$0$1(value, $substring));
    }

    private static final String containOnlyOnce$lambda$0$0(String $value, String $substring, String $failureDescription) {
        return PrintKt.print($value).getValue() + " should contain the substring " + PrintKt.print($substring).getValue() + " exactly once" + $failureDescription;
    }

    private static final String containOnlyOnce$lambda$0$1(String $value, String $substring) {
        return PrintKt.print($value).getValue() + " should not contain the substring " + PrintKt.print($substring).getValue() + " exactly once";
    }

    private static final MatcherResult beEmpty$lambda$0(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(((CharSequence)value).length() == 0, () -> MatchersKt.beEmpty$lambda$0$0(value), () -> MatchersKt.beEmpty$lambda$0$1(value));
    }

    private static final String beEmpty$lambda$0$0(String $value) {
        return PrintKt.print($value).getValue() + " should be empty";
    }

    private static final String beEmpty$lambda$0$1(String $value) {
        return PrintKt.print($value).getValue() + " should not be empty";
    }

    private static final MatcherResult beBlank$lambda$0(String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(StringsKt.isBlank((CharSequence)value), () -> MatchersKt.beBlank$lambda$0$0(value), () -> MatchersKt.beBlank$lambda$0$1(value));
    }

    private static final String beBlank$lambda$0$0(String $value) {
        return PrintKt.print($value).getValue() + " should contain only whitespace";
    }

    private static final String beBlank$lambda$0$1(String $value) {
        return PrintKt.print($value).getValue() + " should not contain only whitespace";
    }

    private static final MatcherResult containIgnoringCase$lambda$0(String $substr, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        CharSequence charSequence = string;
        String string2 = $substr.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        int indexOf = StringsKt.indexOf$default((CharSequence)charSequence, (String)string2, (int)0, (boolean)false, (int)6, null);
        return MatcherResult.Companion.invoke(indexOf >= 0, () -> MatchersKt.containIgnoringCase$lambda$0$0(value, $substr), () -> MatchersKt.containIgnoringCase$lambda$0$1(value, $substr, indexOf));
    }

    private static final String containIgnoringCase$lambda$0$0(String $value, String $substr) {
        return PrintKt.print($value).getValue() + " should contain the substring " + PrintKt.print($substr).getValue() + " (case insensitive)";
    }

    private static final String containIgnoringCase$lambda$0$1(String $value, String $substr, int $indexOf) {
        return PrintKt.print($value).getValue() + " should not contain the substring " + PrintKt.print($substr).getValue() + " (case insensitive), but contained it at index " + $indexOf;
    }

    private static final MatcherResult contain$lambda$0(Regex $regex, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke($regex.containsMatchIn((CharSequence)value), () -> MatchersKt.contain$lambda$0$0(value, $regex), () -> MatchersKt.contain$lambda$0$1(value, $regex));
    }

    private static final String contain$lambda$0$0(String $value, Regex $regex) {
        return PrintKt.print($value).getValue() + " should contain regex " + $regex;
    }

    private static final String contain$lambda$0$1(String $value, Regex $regex) {
        return PrintKt.print($value).getValue() + " should not contain regex " + $regex;
    }

    private static final MatcherResult containInOrder$lambda$0(String[] $substrings, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ContainInOrderOutcome matchOutcome = MatchersKt.matchSubstrings$default(value, ArraysKt.toList((Object[])$substrings), 0, 4, null);
        String substringFoundEarlier = matchOutcome instanceof ContainInOrderOutcome.Mismatch ? StringPartialMatchesKt.describePartialMatchesInStringForSlice$default(((ContainInOrderOutcome.Mismatch)matchOutcome).getSubstring(), value, false, 4, null).toString() : "";
        String[] stringArray = new String[]{matchOutcome.getMistmatchDescription(), substringFoundEarlier};
        String completeMismatchDescription = MatchersKt.joinNonEmpty("\n", stringArray);
        return MatcherResult.Companion.invoke(matchOutcome.getMatch(), () -> MatchersKt.containInOrder$lambda$0$0(value, $substrings, completeMismatchDescription), () -> MatchersKt.containInOrder$lambda$0$1(value, $substrings));
    }

    private static final String containInOrder$lambda$0$0(String $value, String[] $substrings, String $completeMismatchDescription) {
        return PrintKt.print($value).getValue() + " should include substrings " + PrintKt.print($substrings).getValue() + " in order" + MatchersKt.prefixIfNotEmpty($completeMismatchDescription, "\n");
    }

    private static final String containInOrder$lambda$0$1(String $value, String[] $substrings) {
        return PrintKt.print($value).getValue() + " should not include substrings " + PrintKt.print($substrings).getValue() + " in order";
    }

    private static final MatcherResult include$lambda$0(String $substr, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        boolean passed = StringsKt.contains$default((CharSequence)value, (CharSequence)$substr, (boolean)false, (int)2, null);
        Object[] objectArray = new String[]{PrintKt.print(value).getValue() + " should include substring " + PrintKt.print($substr).getValue(), StringPartialMatchesKt.describePartialMatchesInStringForSlice$default($substr, value, false, 4, null).toString()};
        List differencesDescription = CollectionsKt.listOf((Object[])objectArray);
        return (MatcherResult)new ComparisonMatcherResult(passed, StringPrint.INSTANCE.printUnquoted(value), StringPrint.INSTANCE.printUnquoted($substr), () -> MatchersKt.include$lambda$0$0(differencesDescription), () -> MatchersKt.include$lambda$0$1(value, $substr));
    }

    /*
     * WARNING - void declaration
     */
    private static final String include$lambda$0$0(List $differencesDescription) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $differencesDescription;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private static final String include$lambda$0$1(String $value, String $substr) {
        return PrintKt.print($value).getValue() + " should not include substring " + PrintKt.print($substr).getValue();
    }

    private static final MatcherResult beEqualIgnoringCase$lambda$0(String $other, String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MatcherResult.Companion.invoke(StringsKt.equals((String)value, (String)$other, (boolean)true), () -> MatchersKt.beEqualIgnoringCase$lambda$0$0(value, $other), () -> MatchersKt.beEqualIgnoringCase$lambda$0$1(value, $other));
    }

    private static final String beEqualIgnoringCase$lambda$0$0(String $value, String $other) {
        return PrintKt.print($value).getValue() + " should be equal ignoring case " + PrintKt.print($other).getValue();
    }

    private static final String beEqualIgnoringCase$lambda$0$1(String $value, String $other) {
        return PrintKt.print($value).getValue() + " should not be equal ignoring case " + PrintKt.print($other).getValue();
    }
}

