/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.file;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.collections.SizeKt;
import io.kotest.matchers.file.ContentKt;
import io.kotest.matchers.file.MatchersKt;
import io.kotest.matchers.paths.SymbolicKt;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\t\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u0003H\u0002\u001a\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0003\u001a\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\u0015\u0010\f\u001a\u00020\r*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0004\u001a\u0015\u0010\u0010\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0004\u001a\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u0012\u001a\u00020\r*\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0003*\u00020\u0003\u001a\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u0010\u0015\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\u0016\u001a\u00020\b*\u00020\u0003\u001a\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\u0015\u0010\u0018\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u001a\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0019\u001a\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\u001d\u001a\u00020\b*\u00020\u0003\u001a\u0015\u0010\u001e\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010\u001f\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0002H\u0086\u0004\u001a\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\u0019\u001a\u00020\u0002\u001a\n\u0010!\u001a\u00020\b*\u00020\u0003\u001a\n\u0010\"\u001a\u00020\b*\u00020\u0003\u001a\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u0010$\u001a\u00020\b*\u00020\u0003\u001a\n\u0010%\u001a\u00020\b*\u00020\u0003\u001a\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\u0015\u0010'\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010'\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0086\u0004\u001a\u0015\u0010*\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010*\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0086\u0004\u001a\u0014\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010(\u001a\u00020\u0003\u001a\u0015\u0010,\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010,\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0086\u0004\u001a\u0015\u0010-\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010-\u001a\u00020\b*\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0086\u0004\u001a\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010(\u001a\u00020\u0003\u001a\n\u0010/\u001a\u00020\b*\u00020\u0003\u001a\n\u00100\u001a\u00020\b*\u00020\u0003\u001a\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u00102\u001a\u00020\b*\u00020\u0003\u001a\n\u00103\u001a\u00020\b*\u00020\u0003\u001a\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u00105\u001a\u00020\b*\u00020\u0003\u001a\n\u00106\u001a\u00020\b*\u00020\u0003\u001a\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\u0015\u00108\u001a\u00020\b*\u00020\u00032\u0006\u00109\u001a\u00020:H\u0086\u0004\u001a\u0015\u0010;\u001a\u00020\b*\u00020\u00032\u0006\u00109\u001a\u00020:H\u0086\u0004\u001a\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u00109\u001a\u00020:\u001a\n\u0010=\u001a\u00020\b*\u00020\u0003\u001a\n\u0010>\u001a\u00020\b*\u00020\u0003\u001a\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u0010@\u001a\u00020\b*\u00020\u0003\u001a\n\u0010A\u001a\u00020\b*\u00020\u0003\u001a\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u0010C\u001a\u00020\b*\u00020\u0003\u001a\n\u0010D\u001a\u00020\b*\u00020\u0003\u001a\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\n\u0010F\u001a\u00020\b*\u00020\u0003\u001a\n\u0010G\u001a\u00020\b*\u00020\u0003\u001a\f\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u001a\u0015\u0010I\u001a\u00020\b*\u00020\u00032\u0006\u0010J\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010K\u001a\u00020\b*\u00020\u00032\u0006\u0010J\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010I\u001a\u00020\b*\u00020\u00032\u0006\u0010L\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010K\u001a\u00020\b*\u00020\u00032\u0006\u0010L\u001a\u00020\u0002H\u0086\u0004\u001a\u0015\u0010I\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u0003H\u0086\u0004\u001a\u0015\u0010K\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u0003H\u0086\u0004\u001a\u0015\u0010I\u001a\u00020\b*\u00020)2\u0006\u0010J\u001a\u00020)H\u0086\u0004\u001a\u0015\u0010K\u001a\u00020\b*\u00020)2\u0006\u0010J\u001a\u00020)H\u0086\u0004\u001a\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010J\u001a\u00020)\u001a\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010M\u001a\u00020\u0003\u001a\u0014\u0010N\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010L\u001a\u00020\u0002\u001a\u0015\u0010O\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u0003H\u0086\u0004\u001aJ\u0010O\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u000326\u0010P\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bR\u0012\b\b\u0019\u0012\u0004\b\b(S\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bR\u0012\b\b\u0019\u0012\u0004\b\b(T\u0012\u0004\u0012\u00020U0Q\u001a>\u0010O\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u00032\u0014\b\u0002\u0010V\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020U0W2\u0014\b\u0002\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020U0W\u001a\u0015\u0010Y\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u0003H\u0086\u0004\u001aJ\u0010Y\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u000326\u0010P\u001a2\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bR\u0012\b\b\u0019\u0012\u0004\b\b(S\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\bR\u0012\b\b\u0019\u0012\u0004\b\b(T\u0012\u0004\u0012\u00020U0Q\u001a>\u0010Y\u001a\u00020\b*\u00020\u00032\u0006\u0010M\u001a\u00020\u00032\u0014\b\u0002\u0010V\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020U0W2\u0014\b\u0002\u0010X\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020U0W\u00a8\u0006Z"}, d2={"safeList", "", "", "Ljava/io/File;", "safeListFiles", "filter", "Ljava/io/FileFilter;", "shouldBeEmptyDirectory", "", "shouldNotBeEmptyDirectory", "beEmptyDirectory", "Lio/kotest/matchers/Matcher;", "shouldContainNFiles", "", "n", "", "shouldNotContainNFiles", "containNFiles", "shouldBeEmpty", "shouldNotBeEmpty", "emptyFile", "shouldExist", "shouldNotExist", "exist", "shouldContainFile", "name", "shouldNotContainFile", "containFile", "shouldBeSymbolicLink", "shouldNotBeSymbolicLink", "shouldHaveParent", "shouldNotHaveParent", "haveParent", "shouldBeADirectory", "shouldNotBeADirectory", "aDirectory", "shouldBeAFile", "shouldNotBeAFile", "aFile", "shouldBeSmaller", "other", "Ljava/nio/file/Path;", "shouldNotBeSmaller", "beSmaller", "shouldBeLarger", "shouldNotBeLarger", "beLarger", "shouldBeCanonical", "shouldNotBeCanonical", "beCanonicalPath", "shouldBeAbsolute", "shouldNotBeAbsolute", "beAbsolute", "shouldBeRelative", "shouldNotBeRelative", "beRelative", "shouldHaveFileSize", "size", "", "shouldNotHaveFileSize", "haveFileSize", "shouldBeWriteable", "shouldNotBeWriteable", "beWriteable", "shouldBeExecutable", "shouldNotBeExecutable", "beExecutable", "shouldBeHidden", "shouldNotBeHidden", "beHidden", "shouldBeReadable", "shouldNotBeReadable", "beReadable", "shouldStartWithPath", "path", "shouldNotStartWithPath", "prefix", "file", "startWithPath", "shouldHaveSameStructureAs", "compare", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "expect", "actual", "", "filterLhs", "Lkotlin/Function1;", "filterRhs", "shouldHaveSameStructureAndContentAs", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nmatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 matchers.kt\nio/kotest/matchers/file/MatchersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n3544#2,7:344\n3544#2,7:351\n*S KotlinDebug\n*F\n+ 1 matchers.kt\nio/kotest/matchers/file/MatchersKt\n*L\n279#1:344,7\n319#1:351,7\n*E\n"})
public final class MatchersKt {
    private static final List<String> safeList(File $this$safeList) {
        Object object = $this$safeList.list();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<File> safeListFiles(File $this$safeListFiles) {
        Object object = $this$safeListFiles.listFiles();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final List<File> safeListFiles(File $this$safeListFiles, FileFilter filter) {
        Object object = $this$safeListFiles.listFiles(filter);
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final void shouldBeEmptyDirectory(@NotNull File $this$shouldBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmptyDirectory, (String)"<this>");
        ShouldKt.should($this$shouldBeEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    public static final void shouldNotBeEmptyDirectory(@NotNull File $this$shouldNotBeEmptyDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmptyDirectory, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeEmptyDirectory, MatchersKt.beEmptyDirectory());
    }

    @NotNull
    public static final Matcher<File> beEmptyDirectory() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                MatcherResult matcherResult;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (value.isDirectory()) {
                    List contents = MatchersKt.access$safeList(value);
                    matcherResult = MatcherResult.Companion.invoke(contents.isEmpty(), () -> beEmptyDirectory.1.test$lambda$0(value, contents), () -> beEmptyDirectory.1.test$lambda$1(value));
                } else {
                    String reason = value.isFile() ? "was a regular file" : (!value.exists() ? "it does not exist" : "could not determine type");
                    matcherResult = MatcherResult.Companion.invoke(false, () -> beEmptyDirectory.1.test$lambda$2(value, reason), () -> beEmptyDirectory.1.test$lambda$3(value, reason));
                }
                return matcherResult;
            }

            private static final String test$lambda$0(File $value, List $contents) {
                return $value + " should be an empty directory but contained " + $contents.size() + " file(s) [" + CollectionsKt.joinToString$default((Iterable)$contents, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "]";
            }

            private static final String test$lambda$1(File $value) {
                return $value + " should not be a non-empty directory";
            }

            private static final String test$lambda$2(File $value, String $reason) {
                return $value + " should be an empty directory, but " + $reason;
            }

            private static final String test$lambda$3(File $value, String $reason) {
                return $value + " should not be a non-empty directory, but " + $reason;
            }
        };
    }

    @NotNull
    public static final Object shouldContainNFiles(@NotNull File $this$shouldContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainNFiles, (String)"<this>");
        return ShouldKt.shouldBe($this$shouldContainNFiles, MatchersKt.containNFiles(n));
    }

    @NotNull
    public static final File shouldNotContainNFiles(@NotNull File $this$shouldNotContainNFiles, int n) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainNFiles, (String)"<this>");
        return ShouldKt.shouldNotBe($this$shouldNotContainNFiles, MatchersKt.containNFiles(n));
    }

    @NotNull
    public static final Matcher<File> containNFiles(int n) {
        return (Matcher)new Matcher<File>(n){
            final /* synthetic */ int $n;
            {
                this.$n = $n;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory() && MatchersKt.access$safeList(value).size() == this.$n, () -> containNFiles.1.test$lambda$0(value, this.$n), () -> containNFiles.1.test$lambda$1(value, this.$n));
            }

            private static final String test$lambda$0(File $value, int $n) {
                return $value + " should be a directory and contain " + $n + " files";
            }

            private static final String test$lambda$1(File $value, int $n) {
                return $value + " should not be a directory containing " + $n + " files";
            }
        };
    }

    @NotNull
    public static final Object shouldBeEmpty(@NotNull File $this$shouldBeEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeEmpty, (String)"<this>");
        return ShouldKt.shouldBe($this$shouldBeEmpty, MatchersKt.emptyFile());
    }

    @NotNull
    public static final File shouldNotBeEmpty(@NotNull File $this$shouldNotBeEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeEmpty, (String)"<this>");
        return ShouldKt.shouldNotBe($this$shouldNotBeEmpty, MatchersKt.emptyFile());
    }

    @NotNull
    public static final Matcher<File> emptyFile() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == 0L, () -> emptyFile.1.test$lambda$0(value), () -> emptyFile.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be empty";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be empty";
            }
        };
    }

    public static final void shouldExist(@NotNull File $this$shouldExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldExist, (String)"<this>");
        ShouldKt.should($this$shouldExist, MatchersKt.exist());
    }

    public static final void shouldNotExist(@NotNull File $this$shouldNotExist) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotExist, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotExist, MatchersKt.exist());
    }

    @NotNull
    public static final Matcher<File> exist() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.exists(), () -> exist.1.test$lambda$0(value), () -> exist.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should exist";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not exist";
            }
        };
    }

    public static final void shouldContainFile(@NotNull File $this$shouldContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should($this$shouldContainFile, MatchersKt.containFile(name));
    }

    public static final void shouldNotContainFile(@NotNull File $this$shouldNotContainFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotContainFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot($this$shouldNotContainFile, MatchersKt.containFile(name));
    }

    @NotNull
    public static final Matcher<File> containFile(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                List contents = MatchersKt.access$safeList(value);
                boolean passed = value.isDirectory() && contents.contains(this.$name);
                return MatcherResult.Companion.invoke(passed, () -> containFile.1.test$lambda$0(value, this.$name, contents), () -> containFile.1.test$lambda$1(value, this.$name));
            }

            private static final String test$lambda$0(File $value, String $name, List $contents) {
                return "Directory " + $value + " should contain a file with filename " + $name + " (detected " + $contents.size() + " other files)";
            }

            private static final String test$lambda$1(File $value, String $name) {
                return "Directory " + $value + " should not contain a file with filename " + $name;
            }
        };
    }

    public static final void shouldBeSymbolicLink(@NotNull File $this$shouldBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSymbolicLink, (String)"<this>");
        ShouldKt.should($this$shouldBeSymbolicLink.toPath(), SymbolicKt.beSymbolicLink());
    }

    public static final void shouldNotBeSymbolicLink(@NotNull File $this$shouldNotBeSymbolicLink) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSymbolicLink, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeSymbolicLink.toPath(), SymbolicKt.beSymbolicLink());
    }

    public static final void shouldHaveParent(@NotNull File $this$shouldHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.should($this$shouldHaveParent, MatchersKt.haveParent(name));
    }

    public static final void shouldNotHaveParent(@NotNull File $this$shouldNotHaveParent, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveParent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ShouldKt.shouldNot($this$shouldNotHaveParent, MatchersKt.haveParent(name));
    }

    @NotNull
    public static final Matcher<File> haveParent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (Matcher)new Matcher<File>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            private final boolean isParentEqualExpected(File parent) {
                return parent != null && (Intrinsics.areEqual((Object)parent.getName(), (Object)this.$name) || this.isParentEqualExpected(parent.getParentFile()));
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(this.isParentEqualExpected(value.getParentFile()), () -> haveParent.1.test$lambda$0(value, this.$name), () -> haveParent.1.test$lambda$1(value, this.$name));
            }

            private static final String test$lambda$0(File $value, String $name) {
                return "File " + $value + " should have parent " + $name;
            }

            private static final String test$lambda$1(File $value, String $name) {
                return "File " + $value + " should not have parent " + $name;
            }
        };
    }

    public static final void shouldBeADirectory(@NotNull File $this$shouldBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeADirectory, (String)"<this>");
        ShouldKt.should($this$shouldBeADirectory, MatchersKt.aDirectory());
    }

    public static final void shouldNotBeADirectory(@NotNull File $this$shouldNotBeADirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeADirectory, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeADirectory, MatchersKt.aDirectory());
    }

    @NotNull
    public static final Matcher<File> aDirectory() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isDirectory(), () -> aDirectory.1.test$lambda$0(value), () -> aDirectory.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be a directory";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be a directory";
            }
        };
    }

    public static final void shouldBeAFile(@NotNull File $this$shouldBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAFile, (String)"<this>");
        ShouldKt.should($this$shouldBeAFile, MatchersKt.aFile());
    }

    public static final void shouldNotBeAFile(@NotNull File $this$shouldNotBeAFile) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAFile, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeAFile, MatchersKt.aFile());
    }

    @NotNull
    public static final Matcher<File> aFile() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isFile(), () -> aFile.1.test$lambda$0(value), () -> aFile.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be a file";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be a file";
            }
        };
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.should($this$shouldBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldBeSmaller(@NotNull File $this$shouldBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should($this$shouldBeSmaller, MatchersKt.beSmaller(other));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.shouldNot($this$shouldNotBeSmaller, MatchersKt.beSmaller(file));
    }

    public static final void shouldNotBeSmaller(@NotNull File $this$shouldNotBeSmaller, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeSmaller, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot($this$shouldNotBeSmaller, MatchersKt.beSmaller(other));
    }

    @NotNull
    public static final Matcher<File> beSmaller(@NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;
            {
                this.$other = $other;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() < this.$other.length(), () -> beSmaller.1.test$lambda$0(value, sizea, this.$other, sizeb), () -> beSmaller.1.test$lambda$1(value, sizea, this.$other, sizeb));
            }

            private static final String test$lambda$0(File $value, long $sizea, File $other, long $sizeb) {
                return "File " + $value + " (" + $sizea + " bytes) should be smaller than " + $other + " (" + $sizeb + " bytes)";
            }

            private static final String test$lambda$1(File $value, long $sizea, File $other, long $sizeb) {
                return "File " + $value + " (" + $sizea + " bytes) should not be smaller than " + $other + " (" + $sizeb + " bytes)";
            }
        };
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.should($this$shouldBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldBeLarger(@NotNull File $this$shouldBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.should($this$shouldBeLarger, MatchersKt.beLarger(other));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        File file = other.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        ShouldKt.shouldNot($this$shouldNotBeLarger, MatchersKt.beLarger(file));
    }

    public static final void shouldNotBeLarger(@NotNull File $this$shouldNotBeLarger, @NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeLarger, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ShouldKt.shouldNot($this$shouldNotBeLarger, MatchersKt.beLarger(other));
    }

    @NotNull
    public static final Matcher<File> beLarger(@NotNull File other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (Matcher)new Matcher<File>(other){
            final /* synthetic */ File $other;
            {
                this.$other = $other;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                long sizea = value.length();
                long sizeb = this.$other.length();
                return MatcherResult.Companion.invoke(value.length() > this.$other.length(), () -> beLarger.1.test$lambda$0(value, sizea, this.$other, sizeb), () -> beLarger.1.test$lambda$1(value, sizea, this.$other, sizeb));
            }

            private static final String test$lambda$0(File $value, long $sizea, File $other, long $sizeb) {
                return "File " + $value + " (" + $sizea + " bytes) should be larger than " + $other + " (" + $sizeb + " bytes)";
            }

            private static final String test$lambda$1(File $value, long $sizea, File $other, long $sizeb) {
                return "File " + $value + " (" + $sizea + " bytes) should not be larger than " + $other + " (" + $sizeb + " bytes)";
            }
        };
    }

    public static final void shouldBeCanonical(@NotNull File $this$shouldBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeCanonical, (String)"<this>");
        ShouldKt.should($this$shouldBeCanonical, MatchersKt.beCanonicalPath());
    }

    public static final void shouldNotBeCanonical(@NotNull File $this$shouldNotBeCanonical) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeCanonical, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeCanonical, MatchersKt.beCanonicalPath());
    }

    @NotNull
    public static final Matcher<File> beCanonicalPath() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(Intrinsics.areEqual((Object)value.getCanonicalPath(), (Object)value.getPath()), () -> beCanonicalPath.1.test$lambda$0(value), () -> beCanonicalPath.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be canonical";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be canonical";
            }
        };
    }

    public static final void shouldBeAbsolute(@NotNull File $this$shouldBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeAbsolute, (String)"<this>");
        ShouldKt.should($this$shouldBeAbsolute, MatchersKt.beAbsolute());
    }

    public static final void shouldNotBeAbsolute(@NotNull File $this$shouldNotBeAbsolute) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeAbsolute, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeAbsolute, MatchersKt.beAbsolute());
    }

    @NotNull
    public static final Matcher<File> beAbsolute() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isAbsolute(), () -> beAbsolute.1.test$lambda$0(value), () -> beAbsolute.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be absolute";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be absolute";
            }
        };
    }

    public static final void shouldBeRelative(@NotNull File $this$shouldBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeRelative, (String)"<this>");
        ShouldKt.should($this$shouldBeRelative, MatchersKt.beRelative());
    }

    public static final void shouldNotBeRelative(@NotNull File $this$shouldNotBeRelative) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeRelative, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeRelative, MatchersKt.beRelative());
    }

    @NotNull
    public static final Matcher<File> beRelative() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(!value.isAbsolute(), () -> beRelative.1.test$lambda$0(value), () -> beRelative.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be relative";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be relative";
            }
        };
    }

    public static final void shouldHaveFileSize(@NotNull File $this$shouldHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveFileSize, (String)"<this>");
        ShouldKt.should($this$shouldHaveFileSize, MatchersKt.haveFileSize(size));
    }

    public static final void shouldNotHaveFileSize(@NotNull File $this$shouldNotHaveFileSize, long size) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotHaveFileSize, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotHaveFileSize, MatchersKt.haveFileSize(size));
    }

    @NotNull
    public static final Matcher<File> haveFileSize(long size) {
        return (Matcher)new Matcher<File>(size){
            final /* synthetic */ long $size;
            {
                this.$size = $size;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.length() == this.$size, () -> haveFileSize.1.test$lambda$0(value, this.$size), () -> haveFileSize.1.test$lambda$1(value, this.$size));
            }

            private static final String test$lambda$0(File $value, long $size) {
                return "File " + $value + " should have size " + $size;
            }

            private static final String test$lambda$1(File $value, long $size) {
                return "File " + $value + " should not have size " + $size;
            }
        };
    }

    public static final void shouldBeWriteable(@NotNull File $this$shouldBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeWriteable, (String)"<this>");
        ShouldKt.should($this$shouldBeWriteable, MatchersKt.beWriteable());
    }

    public static final void shouldNotBeWriteable(@NotNull File $this$shouldNotBeWriteable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeWriteable, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeWriteable, MatchersKt.beWriteable());
    }

    @NotNull
    public static final Matcher<File> beWriteable() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canWrite(), () -> beWriteable.1.test$lambda$0(value), () -> beWriteable.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be writeable";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be writeable";
            }
        };
    }

    public static final void shouldBeExecutable(@NotNull File $this$shouldBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeExecutable, (String)"<this>");
        ShouldKt.should($this$shouldBeExecutable, MatchersKt.beExecutable());
    }

    public static final void shouldNotBeExecutable(@NotNull File $this$shouldNotBeExecutable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeExecutable, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeExecutable, MatchersKt.beExecutable());
    }

    @NotNull
    public static final Matcher<File> beExecutable() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canExecute(), () -> beExecutable.1.test$lambda$0(value), () -> beExecutable.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be executable";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be executable";
            }
        };
    }

    public static final void shouldBeHidden(@NotNull File $this$shouldBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeHidden, (String)"<this>");
        ShouldKt.should($this$shouldBeHidden, MatchersKt.beHidden());
    }

    public static final void shouldNotBeHidden(@NotNull File $this$shouldNotBeHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeHidden, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeHidden, MatchersKt.beHidden());
    }

    @NotNull
    public static final Matcher<File> beHidden() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.isHidden(), () -> beHidden.1.test$lambda$0(value), () -> beHidden.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be hidden";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be hidden";
            }
        };
    }

    public static final void shouldBeReadable(@NotNull File $this$shouldBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldBeReadable, (String)"<this>");
        ShouldKt.should($this$shouldBeReadable, MatchersKt.beReadable());
    }

    public static final void shouldNotBeReadable(@NotNull File $this$shouldNotBeReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotBeReadable, (String)"<this>");
        ShouldKt.shouldNot($this$shouldNotBeReadable, MatchersKt.beReadable());
    }

    @NotNull
    public static final Matcher<File> beReadable() {
        return (Matcher)new Matcher<File>(){

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return MatcherResult.Companion.invoke(value.canRead(), () -> beReadable.1.test$lambda$0(value), () -> beReadable.1.test$lambda$1(value));
            }

            private static final String test$lambda$0(File $value) {
                return "File " + $value + " should be readable";
            }

            private static final String test$lambda$1(File $value) {
                return "File " + $value + " should not be readable";
            }
        };
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should($this$shouldStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot($this$shouldNotStartWithPath, MatchersKt.startWithPath(path));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.should($this$shouldStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        ShouldKt.shouldNot($this$shouldNotStartWithPath, MatchersKt.startWithPath(prefix));
    }

    public static final void shouldStartWithPath(@NotNull File $this$shouldStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.should($this$shouldStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldNotStartWithPath(@NotNull File $this$shouldNotStartWithPath, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ShouldKt.shouldNot($this$shouldNotStartWithPath, MatchersKt.startWithPath(file));
    }

    public static final void shouldStartWithPath(@NotNull Path $this$shouldStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.should($this$shouldStartWithPath.toFile(), MatchersKt.startWithPath(path));
    }

    public static final void shouldNotStartWithPath(@NotNull Path $this$shouldNotStartWithPath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldNotStartWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        ShouldKt.shouldNot($this$shouldNotStartWithPath.toFile(), MatchersKt.startWithPath(path));
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        return MatchersKt.startWithPath(file);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return MatchersKt.startWithPath(string);
    }

    @NotNull
    public static final Matcher<File> startWithPath(@NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return (Matcher)new Matcher<File>(prefix){
            final /* synthetic */ String $prefix;
            {
                this.$prefix = $prefix;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return MatcherResult.Companion.invoke(StringsKt.startsWith$default((String)string, (String)this.$prefix, (boolean)false, (int)2, null), () -> startWithPath.1.test$lambda$0(value, this.$prefix), () -> startWithPath.1.test$lambda$1(value, this.$prefix));
            }

            private static final String test$lambda$0(File $value, String $prefix) {
                return "File " + $value + " should start with " + $prefix;
            }

            private static final String test$lambda$1(File $value, String $prefix) {
                return "File " + $value + " should not start with " + $prefix;
            }
        };
    }

    public static final void shouldHaveSameStructureAs(@NotNull File $this$shouldHaveSameStructureAs, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MatchersKt.shouldHaveSameStructureAs($this$shouldHaveSameStructureAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)MatchersKt::shouldHaveSameStructureAs$lambda$0));
    }

    /*
     * WARNING - void declaration
     */
    public static final void shouldHaveSameStructureAs(@NotNull File $this$shouldHaveSameStructureAs, @NotNull File file, @NotNull Function2<? super File, ? super File, Boolean> compare) {
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        List expectFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)$this$shouldHaveSameStructureAs)));
        List actualFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)file)));
        String expectParentPath = $this$shouldHaveSameStructureAs.getPath();
        String actualParentPath = file.getPath();
        SizeKt.shouldBeSameSizeAs((Collection)expectFiles, (Collection)actualFiles);
        Iterable iterable = expectFiles;
        Iterable other$iv = actualFiles;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            Object object;
            void actual;
            void expect;
            File file2 = (File)second$iv.next();
            File file3 = (File)first$iv.next();
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (((Boolean)compare.invoke((Object)expect, (Object)actual)).booleanValue()) {
                object = Unit.INSTANCE;
            } else if (expect.isDirectory()) {
                MatchersKt.shouldBeADirectory((File)actual);
                object = Unit.INSTANCE;
            } else if (expect.isFile()) {
                String string = expect.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)expectParentPath);
                String string2 = StringsKt.removePrefix((String)string, (CharSequence)expectParentPath);
                String string3 = actual.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)actualParentPath);
                object = ShouldKt.shouldBe(string2, StringsKt.removePrefix((String)string3, (CharSequence)actualParentPath));
            } else {
                throw new IllegalStateException("There is an unexpected error analyzing file trees".toString());
            }
            arrayList.add((Unit)object);
        }
    }

    public static final void shouldHaveSameStructureAs(@NotNull File $this$shouldHaveSameStructureAs, @NotNull File file, @NotNull Function1<? super File, Boolean> filterLhs, @NotNull Function1<? super File, Boolean> filterRhs) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filterLhs, (String)"filterLhs");
        Intrinsics.checkNotNullParameter(filterRhs, (String)"filterRhs");
        MatchersKt.shouldHaveSameStructureAs($this$shouldHaveSameStructureAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)(arg_0, arg_1) -> MatchersKt.shouldHaveSameStructureAs$lambda$4(filterLhs, filterRhs, arg_0, arg_1)));
    }

    public static /* synthetic */ void shouldHaveSameStructureAs$default(File file, File file2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = MatchersKt::shouldHaveSameStructureAs$lambda$2;
        }
        if ((n & 4) != 0) {
            function12 = MatchersKt::shouldHaveSameStructureAs$lambda$3;
        }
        MatchersKt.shouldHaveSameStructureAs(file, file2, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12);
    }

    public static final void shouldHaveSameStructureAndContentAs(@NotNull File $this$shouldHaveSameStructureAndContentAs, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAndContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        MatchersKt.shouldHaveSameStructureAndContentAs($this$shouldHaveSameStructureAndContentAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)MatchersKt::shouldHaveSameStructureAndContentAs$lambda$0));
    }

    /*
     * WARNING - void declaration
     */
    public static final void shouldHaveSameStructureAndContentAs(@NotNull File $this$shouldHaveSameStructureAndContentAs, @NotNull File file, @NotNull Function2<? super File, ? super File, Boolean> compare) {
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAndContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(compare, (String)"compare");
        List expectFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)$this$shouldHaveSameStructureAndContentAs)));
        List actualFiles = SequencesKt.toList((Sequence)((Sequence)FilesKt.walkTopDown((File)file)));
        String expectParentPath = $this$shouldHaveSameStructureAndContentAs.getPath();
        String actualParentPath = file.getPath();
        SizeKt.shouldBeSameSizeAs((Collection)expectFiles, (Collection)actualFiles);
        Iterable iterable = expectFiles;
        Iterable other$iv = actualFiles;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void actual;
            void expect;
            File file2 = (File)second$iv.next();
            File file3 = (File)first$iv.next();
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            if (!((Boolean)compare.invoke((Object)expect, (Object)actual)).booleanValue()) {
                if (expect.isDirectory()) {
                    MatchersKt.shouldBeADirectory((File)actual);
                } else if (expect.isFile()) {
                    String string = expect.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    Intrinsics.checkNotNull((Object)expectParentPath);
                    String string2 = StringsKt.removePrefix((String)string, (CharSequence)expectParentPath);
                    String string3 = actual.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                    Intrinsics.checkNotNull((Object)actualParentPath);
                    ShouldKt.shouldBe(string2, StringsKt.removePrefix((String)string3, (CharSequence)actualParentPath));
                    ContentKt.shouldHaveSameContentAs$default((File)expect, (File)actual, null, 2, null);
                } else {
                    throw new IllegalStateException("There is an unexpected error analyzing file trees".toString());
                }
            }
            arrayList.add(Unit.INSTANCE);
        }
    }

    public static final void shouldHaveSameStructureAndContentAs(@NotNull File $this$shouldHaveSameStructureAndContentAs, @NotNull File file, @NotNull Function1<? super File, Boolean> filterLhs, @NotNull Function1<? super File, Boolean> filterRhs) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameStructureAndContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filterLhs, (String)"filterLhs");
        Intrinsics.checkNotNullParameter(filterRhs, (String)"filterRhs");
        MatchersKt.shouldHaveSameStructureAndContentAs($this$shouldHaveSameStructureAndContentAs, file, (Function2<? super File, ? super File, Boolean>)((Function2)(arg_0, arg_1) -> MatchersKt.shouldHaveSameStructureAndContentAs$lambda$4(filterLhs, filterRhs, arg_0, arg_1)));
    }

    public static /* synthetic */ void shouldHaveSameStructureAndContentAs$default(File file, File file2, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = MatchersKt::shouldHaveSameStructureAndContentAs$lambda$2;
        }
        if ((n & 4) != 0) {
            function12 = MatchersKt::shouldHaveSameStructureAndContentAs$lambda$3;
        }
        MatchersKt.shouldHaveSameStructureAndContentAs(file, file2, (Function1<? super File, Boolean>)function1, (Function1<? super File, Boolean>)function12);
    }

    private static final boolean shouldHaveSameStructureAs$lambda$0(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"<unused var>");
        return false;
    }

    private static final boolean shouldHaveSameStructureAs$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean shouldHaveSameStructureAs$lambda$3(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean shouldHaveSameStructureAs$lambda$4(Function1 $filterLhs, Function1 $filterRhs, File expect, File actual) {
        Intrinsics.checkNotNullParameter((Object)expect, (String)"expect");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        return (Boolean)$filterLhs.invoke((Object)expect) != false || (Boolean)$filterRhs.invoke((Object)actual) != false;
    }

    private static final boolean shouldHaveSameStructureAndContentAs$lambda$0(File file, File file2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"<unused var>");
        return false;
    }

    private static final boolean shouldHaveSameStructureAndContentAs$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean shouldHaveSameStructureAndContentAs$lambda$3(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return false;
    }

    private static final boolean shouldHaveSameStructureAndContentAs$lambda$4(Function1 $filterLhs, Function1 $filterRhs, File expect, File actual) {
        Intrinsics.checkNotNullParameter((Object)expect, (String)"expect");
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        return (Boolean)$filterLhs.invoke((Object)expect) != false || (Boolean)$filterRhs.invoke((Object)actual) != false;
    }

    public static final /* synthetic */ List access$safeList(File $receiver) {
        return MatchersKt.safeList($receiver);
    }
}

