/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.assertions.eq;

import io.kotest.assertions.Actual;
import io.kotest.assertions.AssertionErrorBuilder;
import io.kotest.assertions.Expected;
import io.kotest.assertions.eq.Eq;
import io.kotest.assertions.eq.EqCompare;
import io.kotest.assertions.print.PrintKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J/\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/kotest/assertions/eq/ArrayEq;", "Lio/kotest/assertions/eq/Eq;", "", "<init>", "()V", "equals", "", "actual", "expected", "strictNumberEq", "", "([Ljava/lang/Object;[Ljava/lang/Object;Z)Ljava/lang/Throwable;", "TRIGGER", "", "DISALLOWED", "kotest-assertions-core"})
@SourceDebugExtension(value={"SMAP\nArrayEq.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArrayEq.kt\nio/kotest/assertions/eq/ArrayEq\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class ArrayEq
implements Eq<Object[]> {
    @NotNull
    public static final ArrayEq INSTANCE = new ArrayEq();
    @NotNull
    public static final String TRIGGER = "Disallowed";
    @NotNull
    private static final String DISALLOWED = "Disallowed nesting array";

    private ArrayEq() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Throwable equals(@NotNull Object[] actual, @NotNull Object[] expected, boolean strictNumberEq) {
        Throwable throwable;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Iterator iter1 = ArrayIteratorKt.iterator((Object[])actual);
        Iterator iter2 = ArrayIteratorKt.iterator((Object[])expected);
        List elementDifferAtIndex = new ArrayList();
        Ref.ObjectRef nestedIteratorError = new Ref.ObjectRef();
        Ref.BooleanRef accrueDetails = new Ref.BooleanRef();
        accrueDetails.element = true;
        int index = 0;
        Integer unexpectedElementAtIndex = null;
        Integer missingElementAt = null;
        while (iter1.hasNext()) {
            Object a = iter1.next();
            if (iter2.hasNext()) {
                Throwable t;
                Throwable throwable2;
                Object b = iter2.next();
                Object e = a;
                boolean bl = e != null ? e.equals(b) : false;
                if (bl) {
                    throwable2 = null;
                } else {
                    boolean bl2;
                    String it;
                    if (ArrayEq.equals$nestedIterator(a, actual) != null) {
                        boolean bl3 = false;
                        bl2 = ArrayEq.equals$setDisallowedState((Ref.ObjectRef<String>)nestedIteratorError, accrueDetails, it);
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        AssertionErrorBuilder assertionErrorBuilder = AssertionErrorBuilder.Companion.create();
                        Object object = nestedIteratorError.element;
                        Intrinsics.checkNotNull((Object)object);
                        throwable2 = (Throwable)((Object)assertionErrorBuilder.withMessage((String)object).build());
                    } else {
                        boolean bl4;
                        if (ArrayEq.equals$nestedIterator(b, expected) != null) {
                            boolean bl5 = false;
                            bl4 = ArrayEq.equals$setDisallowedState((Ref.ObjectRef<String>)nestedIteratorError, accrueDetails, it);
                        } else {
                            bl4 = false;
                        }
                        if (bl4) {
                            AssertionErrorBuilder assertionErrorBuilder = AssertionErrorBuilder.Companion.create();
                            Object object = nestedIteratorError.element;
                            Intrinsics.checkNotNull((Object)object);
                            throwable2 = (Throwable)((Object)assertionErrorBuilder.withMessage((String)object).build());
                        } else {
                            throwable2 = t = ArrayEq.equals$equalXorDisallowed((Ref.ObjectRef<String>)nestedIteratorError, accrueDetails, EqCompare.INSTANCE.compare(a, b, strictNumberEq));
                        }
                    }
                }
                if (!accrueDetails.element) break;
                if (t != null) {
                    elementDifferAtIndex.add(index);
                }
            } else {
                unexpectedElementAtIndex = index;
            }
            ++index;
        }
        if (iter2.hasNext() && accrueDetails.element) {
            missingElementAt = index;
        }
        StringBuilder $this$equals_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!((Collection)elementDifferAtIndex).isEmpty()) {
            $this$equals_u24lambda_u244.append("Element differ at index: " + PrintKt.print(elementDifferAtIndex).getValue() + "\n");
        }
        if (unexpectedElementAtIndex != null) {
            $this$equals_u24lambda_u244.append("Unexpected elements from index " + unexpectedElementAtIndex + "\n");
        }
        if (missingElementAt != null) {
            $this$equals_u24lambda_u244.append("Missing elements from index " + missingElementAt + "\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String detailErrorMessage = string;
        Object object = (String)nestedIteratorError.element;
        if (object != null) {
            String it = object;
            boolean bl6 = false;
            AssertionError assertionError = AssertionErrorBuilder.Companion.create().withMessage(it).build();
            object = assertionError;
            if (assertionError != null) {
                throwable = (Throwable)object;
                return throwable;
            }
        }
        if (StringsKt.isBlank((CharSequence)detailErrorMessage)) return null;
        boolean bl7 = true;
        if (!bl7) return null;
        throwable = (Throwable)((Object)AssertionErrorBuilder.Companion.create().withMessage(detailErrorMessage).withValues(new Expected(PrintKt.print(expected)), new Actual(PrintKt.print(actual))).build());
        return throwable;
    }

    private static final <T> String equals$nestedIterator(T item, Object[] other) {
        String string;
        T t = item;
        if (t != null) {
            T it = t;
            boolean bl = false;
            if (Reflection.getOrCreateKotlinClass(it.getClass()).isInstance((Object)other) || Reflection.getOrCreateKotlinClass(other.getClass()).isInstance(it)) {
                String string2;
                String string3 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                if (string3 == null) {
                    string3 = "anonymous";
                }
                if ((string2 = Reflection.getOrCreateKotlinClass(other.getClass()).getSimpleName()) == null) {
                    string2 = "anonymous";
                }
                string = "Disallowed nesting array " + it + " (" + string3 + ") within " + other + " (" + string2 + "); (use custom test code instead)";
            } else {
                string = null;
            }
        } else {
            string = null;
        }
        return string;
    }

    private static final boolean equals$setDisallowedState(Ref.ObjectRef<String> nestedIteratorError, Ref.BooleanRef accrueDetails, String disallowedMsg) {
        nestedIteratorError.element = disallowedMsg;
        accrueDetails.element = false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Throwable equals$equalXorDisallowed(Ref.ObjectRef<String> nestedIteratorError, Ref.BooleanRef accrueDetails, Throwable signal) {
        Throwable throwable;
        Throwable throwable2 = signal;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            String string = it.getMessage();
            boolean bl2 = string != null ? StringsKt.startsWith$default((String)string, (String)DISALLOWED, (boolean)false, (int)2, null) : false;
            if (bl2) {
                String string2 = it.getMessage();
                Intrinsics.checkNotNull((Object)string2);
                ArrayEq.equals$setDisallowedState(nestedIteratorError, accrueDetails, string2);
                AssertionErrorBuilder assertionErrorBuilder = AssertionErrorBuilder.Companion.create();
                Object object = nestedIteratorError.element;
                Intrinsics.checkNotNull((Object)object);
                throwable = (Throwable)((Object)assertionErrorBuilder.withMessage((String)object).build());
            } else {
                void var3_3;
                throwable = var3_3;
            }
        } else {
            throwable = null;
        }
        return throwable;
    }
}

