/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.file;

import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.file.ContentKt;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"shouldHaveSameContentAs", "", "Ljava/io/File;", "other", "charset", "Ljava/nio/charset/Charset;", "kotest-assertions-core"})
public final class ContentKt {
    public static final void shouldHaveSameContentAs(@NotNull File $this$shouldHaveSameContentAs, @NotNull File other, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$shouldHaveSameContentAs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        ShouldKt.should($this$shouldHaveSameContentAs, (Matcher)new Matcher<File>(charset, other){
            final /* synthetic */ Charset $charset;
            final /* synthetic */ File $other;
            {
                this.$charset = $charset;
                this.$other = $other;
            }

            public MatcherResult test(File value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                BufferedReader lines1 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(value), this.$charset));
                BufferedReader lines2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.$other), this.$charset));
                boolean passed = true;
                int index = 0;
                String a = "";
                String b = "";
                while (passed && a != null && b != null) {
                    a = lines1.readLine();
                    b = lines2.readLine();
                    passed = Intrinsics.areEqual((Object)a, (Object)b);
                    ++index;
                }
                lines1.close();
                lines2.close();
                String diff = a == null ? "File " + this.$other + " has additional lines, starting at line " + index + ": " + b : (b == null ? "File " + value + " has additional lines, starting at line " + index + ": " + a : "Instead they differ at line " + index + ":\n+ " + a + "\n- " + b);
                return MatcherResult.Companion.invoke(passed, () -> shouldHaveSameContentAs.1.test$lambda$0(value, this.$other, diff), () -> shouldHaveSameContentAs.1.test$lambda$1(value, this.$other));
            }

            private static final String test$lambda$0(File $value, File $other, String $diff) {
                return "Files " + $value + " and " + $other + " should have the same content.\n" + $diff;
            }

            private static final String test$lambda$1(File $value, File $other) {
                return "Files " + $value + " and " + $other + " should not have the same content";
            }
        });
    }

    public static /* synthetic */ void shouldHaveSameContentAs$default(File file, File file2, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = Charset.forName("utf8");
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"forName(...)");
            charset = charset2;
        }
        ContentKt.shouldHaveSameContentAs(file, file2, charset);
    }
}

