/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.collections;

import io.kotest.assertions.print.PrintKt;
import io.kotest.assertions.similarity.PossibleMatchesForSetKt;
import io.kotest.matchers.Matcher;
import io.kotest.matchers.MatcherResult;
import io.kotest.matchers.ShouldKt;
import io.kotest.matchers.collections.BeinKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a&\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\u0004\u00a2\u0006\u0002\u0010\u0004\u001a&\u0010\u0005\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\u0004\u00a2\u0006\u0002\u0010\u0004\u001a)\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00010\u0007\"\u0002H\u0001\u00a2\u0006\u0002\u0010\b\u001a)\u0010\u0005\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00010\u0007\"\u0002H\u0001\u00a2\u0006\u0002\u0010\b\u001a(\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0087\u0004\u00a2\u0006\u0004\b\n\u0010\b\u001a(\u0010\u0005\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\u0002H\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007H\u0087\u0004\u00a2\u0006\u0004\b\u000b\u0010\b\u001a \u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00010\r\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0000\u00a8\u0006\u0012"}, d2={"shouldBeIn", "T", "collection", "", "(Ljava/lang/Object;Ljava/util/Collection;)Ljava/lang/Object;", "shouldNotBeIn", "any", "", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;", "array", "shouldBeInArray", "shouldNotBeInArray", "beIn", "Lio/kotest/matchers/Matcher;", "prefixIfNotEmpty", "", "value", "prefix", "kotest-assertions-core"})
public final class BeinKt {
    public static final <T> T shouldBeIn(T $this$shouldBeIn, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        ShouldKt.should($this$shouldBeIn, BeinKt.beIn(collection));
        return $this$shouldBeIn;
    }

    public static final <T> T shouldNotBeIn(T $this$shouldNotBeIn, @NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        ShouldKt.shouldNot($this$shouldNotBeIn, BeinKt.beIn(CollectionsKt.toList((Iterable)collection)));
        return $this$shouldNotBeIn;
    }

    public static final <T> T shouldBeIn(T $this$shouldBeIn, T ... any2) {
        Intrinsics.checkNotNullParameter(any2, (String)"any");
        ShouldKt.should($this$shouldBeIn, BeinKt.beIn(ArraysKt.toList((Object[])any2)));
        return $this$shouldBeIn;
    }

    public static final <T> T shouldNotBeIn(T $this$shouldNotBeIn, T ... any2) {
        Intrinsics.checkNotNullParameter(any2, (String)"any");
        ShouldKt.shouldNot($this$shouldNotBeIn, BeinKt.beIn(ArraysKt.toList((Object[])any2)));
        return $this$shouldNotBeIn;
    }

    @JvmName(name="shouldBeInArray")
    public static final <T> T shouldBeInArray(T $this$shouldBeIn, @NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        ShouldKt.should($this$shouldBeIn, BeinKt.beIn(ArraysKt.toList((Object[])array)));
        return $this$shouldBeIn;
    }

    @JvmName(name="shouldNotBeInArray")
    public static final <T> T shouldNotBeInArray(T $this$shouldNotBeIn, @NotNull T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        ShouldKt.shouldNot($this$shouldNotBeIn, BeinKt.beIn(ArraysKt.toList((Object[])array)));
        return $this$shouldNotBeIn;
    }

    @NotNull
    public static final <T> Matcher<T> beIn(@NotNull Collection<? extends T> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        return new Matcher<T>(collection){
            final /* synthetic */ Collection<T> $collection;
            {
                this.$collection = $collection;
            }

            public MatcherResult test(T value) {
                boolean match = this.$collection.contains(value);
                String possibleMatchesDescription = BeinKt.prefixIfNotEmpty(PossibleMatchesForSetKt.possibleMatchesForSet(match, SetsKt.setOf(value), CollectionsKt.toSet((Iterable)this.$collection), null), "\n");
                return MatcherResult.Companion.invoke(match, () -> beIn.1.test$lambda$0(value, this.$collection, possibleMatchesDescription), () -> beIn.1.test$lambda$1(value, this.$collection));
            }

            private static final String test$lambda$0(Object $value, Collection $collection, String $possibleMatchesDescription) {
                return "Collection should contain " + PrintKt.print($value).getValue() + ", but doesn't. Possible values: " + PrintKt.print($collection).getValue() + $possibleMatchesDescription;
            }

            private static final String test$lambda$1(Object $value, Collection $collection) {
                return "Collection should not contain " + PrintKt.print($value).getValue() + ", but does. Forbidden values: " + PrintKt.print($collection).getValue();
            }
        };
    }

    @NotNull
    public static final String prefixIfNotEmpty(@NotNull String value, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        return ((CharSequence)value).length() == 0 ? "" : prefix + value;
    }
}

