/*
 * Decompiled with CFR 0.152.
 */
package io.kotest.matchers.concurrent;

import io.kotest.assertions.AssertionErrorBuilder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u001a/\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a2\u0006\u0002\u0010\b\u001a*\u0010\t\u001a\u00020\n\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0007\u00a8\u0006\u000b"}, d2={"shouldCompleteWithin", "A", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "thunk", "Lkotlin/Function0;", "(JLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shouldTimeout", "", "kotest-assertions-core"})
public final class ConcurrentKt {
    public static final <A> A shouldCompleteWithin(long timeout, @NotNull TimeUnit unit, @NotNull Function0<? extends A> thunk) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(thunk, (String)"thunk");
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ConcurrentKt.shouldCompleteWithin$lambda$0(thunk, ref, latch), (int)31, null);
        if (!latch.await(timeout, unit)) {
            t.interrupt();
            AssertionErrorBuilder.Companion.fail("Test should have completed within " + timeout + "/" + unit);
            throw new KotlinNothingValueException();
        }
        return ref.get();
    }

    public static final <A> void shouldTimeout(long timeout, @NotNull TimeUnit unit, @NotNull Function0<? extends A> thunk) {
        boolean timedOut;
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(thunk, (String)"thunk");
        CountDownLatch latch = new CountDownLatch(1);
        Thread t = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, () -> ConcurrentKt.shouldTimeout$lambda$1(thunk, latch), (int)31, null);
        boolean bl = timedOut = !latch.await(timeout, unit);
        if (!timedOut) {
            AssertionErrorBuilder.Companion.fail("Expected test to timeout for " + timeout + "/" + unit);
            throw new KotlinNothingValueException();
        }
        t.interrupt();
    }

    private static final Unit shouldCompleteWithin$lambda$0(Function0 $thunk, AtomicReference $ref, CountDownLatch $latch) {
        Object a = $thunk.invoke();
        $ref.set(a);
        $latch.countDown();
        return Unit.INSTANCE;
    }

    private static final Unit shouldTimeout$lambda$1(Function0 $thunk, CountDownLatch $latch) {
        $thunk.invoke();
        $latch.countDown();
        return Unit.INSTANCE;
    }
}

