/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.annotation.Immutable;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.config.Instantiator;
import io.debezium.util.Collect;
import io.debezium.util.IoUtil;
import io.debezium.util.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public interface Configuration {
    public static final Logger CONFIGURATION_LOGGER = LoggerFactory.getLogger(Configuration.class);
    public static final Pattern PASSWORD_PATTERN = Pattern.compile(".*password$|.*sasl\\.jaas\\.config$", 2);

    public static Builder create() {
        return new Builder();
    }

    public static Builder copy(Configuration config) {
        return config != null ? new Builder(config.asProperties()) : new Builder();
    }

    public static Configuration fromSystemProperties(String prefix) {
        return Configuration.empty().withSystemProperties(prefix);
    }

    public static Configuration empty() {
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Collections.emptySet();
            }

            @Override
            public String getString(String key) {
                return null;
            }

            public String toString() {
                return "{}";
            }
        };
    }

    public static Configuration from(Properties properties) {
        final Properties props = new Properties();
        if (properties != null) {
            props.putAll((Map<?, ?>)properties);
        }
        return new Configuration(){

            @Override
            public String getString(String key) {
                return props.getProperty(key);
            }

            @Override
            public Set<String> keys() {
                return props.stringPropertyNames();
            }

            public String toString() {
                return this.withMaskedPasswords().asProperties().toString();
            }
        };
    }

    public static Configuration from(Map<String, ?> properties) {
        return Configuration.from(properties, value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof Collection) {
                return Strings.join((CharSequence)",", (List)value);
            }
            return value.toString();
        });
    }

    public static <T> Configuration from(Map<String, T> properties, final Function<T, String> conversion) {
        final HashMap<String, T> props = new HashMap<String, T>();
        if (properties != null) {
            props.putAll(properties);
        }
        return new Configuration(){

            @Override
            public String getString(String key) {
                return (String)conversion.apply(props.get(key));
            }

            @Override
            public Set<String> keys() {
                return props.keySet();
            }

            public String toString() {
                return this.withMaskedPasswords().asProperties().toString();
            }
        };
    }

    public static Configuration load(URL url) throws IOException {
        try (InputStream stream = url.openStream();){
            Configuration configuration = Configuration.load(stream);
            return configuration;
        }
    }

    public static Configuration load(File file) throws IOException {
        try (FileInputStream stream = new FileInputStream(file);){
            Configuration configuration = Configuration.load(stream);
            return configuration;
        }
    }

    public static Configuration load(InputStream stream) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(stream);
            Configuration configuration = Configuration.from(properties);
            return configuration;
        }
        finally {
            stream.close();
        }
    }

    public static Configuration load(Reader reader) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(reader);
            Configuration configuration = Configuration.from(properties);
            return configuration;
        }
        finally {
            reader.close();
        }
    }

    public static Configuration load(String path, Class<?> clazz) throws IOException {
        return Configuration.load(path, clazz.getClassLoader());
    }

    public static Configuration load(String path, ClassLoader classLoader) throws IOException {
        Logger logger = LoggerFactory.getLogger(Configuration.class);
        return Configuration.load(path, classLoader, logger::debug);
    }

    public static Configuration load(String path, ClassLoader classLoader, Consumer<String> logger) throws IOException {
        try (InputStream stream = IoUtil.getResourceAsStream(path, classLoader, null, null, logger);){
            Properties props = new Properties();
            if (stream != null) {
                props.load(stream);
            }
            Configuration configuration = Configuration.from(props);
            return configuration;
        }
    }

    default public Builder edit() {
        return Configuration.copy(this);
    }

    default public boolean hasKey(String key) {
        return this.getString(key) != null;
    }

    default public boolean hasKey(Field field) {
        return this.hasKey(field.name());
    }

    public Set<String> keys();

    public String getString(String var1);

    default public String getString(String key, String defaultValue) {
        return this.getString(key, () -> defaultValue);
    }

    default public String getString(String key, Supplier<String> defaultValueSupplier) {
        String value = this.getString(key);
        return value != null ? value : (defaultValueSupplier != null ? defaultValueSupplier.get() : null);
    }

    default public String getString(Field field) {
        return this.getString(field.name(), field.defaultValueAsString());
    }

    default public String getString(Field field, String defaultValue) {
        return this.getString(field.name(), () -> {
            String value = field.defaultValueAsString();
            return value != null ? value : defaultValue;
        });
    }

    default public List<String> getStrings(Field field, String regex) {
        return this.getStrings(field.name(), regex);
    }

    default public List<String> getStrings(String key, String regex) {
        String value = this.getString(key);
        if (value == null) {
            return null;
        }
        return Collect.arrayListOf(value.split(regex));
    }

    default public List<String> getTrimmedStrings(Field field, String regex) {
        String value = this.getString(field);
        if (value == null) {
            return null;
        }
        return Arrays.stream(value.split(regex)).map(String::trim).collect(Collectors.toList());
    }

    default public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    default public Long getLong(String key) {
        return this.getLong(key, null);
    }

    default public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    default public int getInteger(String key, int defaultValue) {
        return this.getInteger(key, () -> defaultValue);
    }

    default public long getLong(String key, long defaultValue) {
        return this.getLong(key, () -> defaultValue);
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, () -> defaultValue);
    }

    default public Number getNumber(String key, Supplier<Number> defaultValueSupplier) {
        String value = this.getString(key);
        return Strings.asNumber(value, defaultValueSupplier);
    }

    default public Integer getInteger(String key, IntSupplier defaultValueSupplier) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValueSupplier != null ? Integer.valueOf(defaultValueSupplier.getAsInt()) : null;
    }

    default public Long getLong(String key, LongSupplier defaultValueSupplier) {
        String value = this.getString(key);
        if (value != null) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValueSupplier != null ? Long.valueOf(defaultValueSupplier.getAsLong()) : null;
    }

    default public Boolean getBoolean(String key, BooleanSupplier defaultValueSupplier) {
        String value = this.getString(key);
        if (value != null) {
            if (Boolean.valueOf(value = value.trim().toLowerCase()).booleanValue()) {
                return Boolean.TRUE;
            }
            if (value.equals("false")) {
                return false;
            }
        }
        return defaultValueSupplier != null ? Boolean.valueOf(defaultValueSupplier.getAsBoolean()) : null;
    }

    default public Number getNumber(Field field) {
        return this.getNumber(field.name(), () -> Strings.asNumber(field.defaultValueAsString()));
    }

    default public int getInteger(Field field) {
        return this.getInteger(field.name(), () -> Integer.valueOf(field.defaultValueAsString()));
    }

    default public long getLong(Field field) {
        return this.getLong(field.name(), () -> Long.valueOf(field.defaultValueAsString()));
    }

    default public boolean getBoolean(Field field) {
        return this.getBoolean(field.name(), () -> Boolean.valueOf(field.defaultValueAsString()));
    }

    default public int getInteger(Field field, int defaultValue) {
        return this.getInteger(field.name(), defaultValue);
    }

    default public long getLong(Field field, long defaultValue) {
        return this.getLong(field.name(), defaultValue);
    }

    default public boolean getBoolean(Field field, boolean defaultValue) {
        return this.getBoolean(field.name(), defaultValue);
    }

    default public Integer getInteger(Field field, IntSupplier defaultValueSupplier) {
        return this.getInteger(field.name(), defaultValueSupplier);
    }

    default public Long getLong(Field field, LongSupplier defaultValueSupplier) {
        return this.getLong(field.name(), defaultValueSupplier);
    }

    default public Boolean getBoolean(Field field, BooleanSupplier defaultValueSupplier) {
        return this.getBoolean(field.name(), defaultValueSupplier);
    }

    default public String getString(Field field, Supplier<String> defaultValueSupplier) {
        return this.getString(field.name(), defaultValueSupplier);
    }

    default public Duration getDuration(Field field, TemporalUnit unit) {
        return Duration.of(this.getLong(field), unit);
    }

    default public <T> T getInstance(String key, Class<T> type) {
        return this.getInstance(key, type, () -> Thread.currentThread().getContextClassLoader());
    }

    default public <T> T getInstance(String key, Class<T> type, Supplier<ClassLoader> classloaderSupplier) {
        return Instantiator.getInstance(this.getString(key), classloaderSupplier, null);
    }

    default public <T> T getInstance(String key, Class<T> clazz, Configuration configuration) {
        return Instantiator.getInstance(this.getString(key), () -> Thread.currentThread().getContextClassLoader(), configuration);
    }

    default public <T> T getInstance(Field field, Class<T> clazz) {
        return this.getInstance(field, clazz, () -> Thread.currentThread().getContextClassLoader());
    }

    default public <T> T getInstance(Field field, Class<T> type, Supplier<ClassLoader> classloaderSupplier) {
        return Instantiator.getInstance(this.getString(field), classloaderSupplier, null);
    }

    default public <T> T getInstance(Field field, Class<T> clazz, Configuration configuration) {
        return Instantiator.getInstance(this.getString(field), () -> Thread.currentThread().getContextClassLoader(), configuration);
    }

    default public <T> T getInstance(Field field, Class<T> clazz, Properties props) {
        return Instantiator.getInstanceWithProperties(this.getString(field), () -> Thread.currentThread().getContextClassLoader(), props);
    }

    default public Configuration subset(String prefix, boolean removePrefix) {
        if (prefix == null) {
            return this;
        }
        if ((prefix = prefix.trim()).isEmpty()) {
            return this;
        }
        String prefixWithSeparator = prefix.endsWith(".") ? prefix : prefix + ".";
        int minLength = prefixWithSeparator.length();
        Function<String, String> prefixRemover = removePrefix ? key -> key.substring(minLength) : key -> key;
        return this.filter(key -> key != null && key.startsWith(prefixWithSeparator)).map(prefixRemover);
    }

    default public Configuration map(Function<String, String> mapper) {
        if (mapper == null) {
            return this;
        }
        final HashMap newToOld = new HashMap();
        this.keys().stream().filter((? super T k) -> k != null).forEach((? super T oldKey) -> {
            String newKey = (String)mapper.apply((String)oldKey);
            if (newKey != null) {
                newToOld.put(newKey, oldKey);
            }
        });
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Collect.unmodifiableSet(newToOld.keySet());
            }

            @Override
            public String getString(String key) {
                String oldKey = (String)newToOld.get(key);
                return Configuration.this.getString(oldKey);
            }

            public String toString() {
                return this.withMaskedPasswords().asProperties().toString();
            }
        };
    }

    default public Configuration filter(final Predicate<? super String> matcher) {
        if (matcher == null) {
            return this;
        }
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Collect.unmodifiableSet(Configuration.this.keys().stream().filter((? super T k) -> k != null).filter(matcher).collect(Collectors.toSet()));
            }

            @Override
            public String getString(String key) {
                return matcher.test(key) ? Configuration.this.getString(key) : null;
            }

            public String toString() {
                return this.withMaskedPasswords().asProperties().toString();
            }
        };
    }

    default public Configuration mapped(final BiFunction<? super String, ? super String, String> mapper) {
        if (mapper == null) {
            return this;
        }
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Configuration.this.keys();
            }

            @Override
            public String getString(String key) {
                return (String)mapper.apply(key, Configuration.this.getString(key));
            }

            public String toString() {
                return this.withMaskedPasswords().asProperties().toString();
            }
        };
    }

    default public Configuration withReplacedVariables(Function<String, String> valuesByVariableName) {
        return this.mapped((key, value) -> Strings.replaceVariables(value, valuesByVariableName));
    }

    default public Configuration withMaskedPasswords() {
        return this.withMasked(PASSWORD_PATTERN);
    }

    default public Configuration withMasked(String keyRegex) {
        if (keyRegex == null) {
            return this;
        }
        return this.withMasked(Pattern.compile(keyRegex));
    }

    default public Configuration withMasked(final Pattern keyRegex) {
        if (keyRegex == null) {
            return this;
        }
        return new Configuration(){

            @Override
            public Set<String> keys() {
                return Configuration.this.keys();
            }

            @Override
            public String getString(String key) {
                boolean matches = keyRegex.matcher(key).matches();
                return matches ? "********" : Configuration.this.getString(key);
            }

            public String toString() {
                return this.withMaskedPasswords().asProperties().toString();
            }
        };
    }

    default public boolean isEmpty() {
        return this.keys().isEmpty();
    }

    default public Properties asProperties() {
        return this.asProperties(null);
    }

    default public Properties asProperties(Field.Set fields) {
        Properties props = new Properties();
        this.keys().forEach((? super T key) -> {
            String value = this.getString((String)key);
            if (key != null && value != null) {
                props.setProperty((String)key, value);
            }
        });
        if (fields != null) {
            fields.forEach((? super T field) -> props.put(field.name(), this.getString((Field)field)));
        }
        return props;
    }

    default public Map<String, String> asMap() {
        return this.asMap(null);
    }

    default public Map<String, String> asMap(Field.Set fields) {
        HashMap<String, String> props = new HashMap<String, String>();
        this.keys().forEach((? super T key) -> {
            String value = this.getString((String)key);
            if (key != null && value != null) {
                props.put((String)key, value);
            }
        });
        if (fields != null) {
            fields.forEach((? super T field) -> props.put(field.name(), this.getString((Field)field)));
        }
        return props;
    }

    default public Configuration withSystemProperties(String prefix) {
        int prefixLength = prefix.length();
        return this.withSystemProperties((String input) -> {
            String withoutPrefix;
            if (input.startsWith(prefix) && (withoutPrefix = input.substring(prefixLength).trim()).length() > 0) {
                return withoutPrefix.toLowerCase().replaceAll("[_]", ".");
            }
            return null;
        });
    }

    default public Configuration withSystemProperties(Function<String, String> propertyNameConverter) {
        Properties props = this.asProperties();
        Properties systemProperties = System.getProperties();
        for (String key : systemProperties.stringPropertyNames()) {
            String propName = propertyNameConverter.apply(key);
            if (propName == null || propName.length() <= 0) continue;
            String value = systemProperties.getProperty(key);
            props.setProperty(propName, value);
        }
        return Configuration.from(props);
    }

    default public boolean validate(Iterable<Field> fields, Field.ValidationOutput problems) {
        boolean valid = true;
        for (Field field : fields) {
            if (field.validate(this, problems)) continue;
            valid = false;
        }
        return valid;
    }

    default public boolean validateAndRecord(Iterable<Field> fields, Consumer<String> problems) {
        return this.validate(fields, (f, v, problem) -> {
            if (v == null) {
                problems.accept("The '" + f.name() + "' value is invalid: " + problem);
            } else {
                String valueStr = v.toString();
                if (v instanceof CharSequence) {
                    valueStr = PASSWORD_PATTERN.matcher((CharSequence)v).matches() ? "********" : "'" + valueStr + "'";
                }
                problems.accept("The '" + f.name() + "' value " + valueStr + " is invalid: " + problem);
            }
        });
    }

    default public Map<String, ConfigValue> validate(Field.Set fields) {
        HashMap<String, ConfigValue> configValuesByFieldName = new HashMap<String, ConfigValue>();
        fields.forEach((? super T field) -> configValuesByFieldName.put(field.name(), new ConfigValue(field.name())));
        fields.forEachMissingDependent(missingDepedent -> {
            ConfigValue undefinedConfigValue = new ConfigValue((String)missingDepedent);
            undefinedConfigValue.addErrorMessage(missingDepedent + " is referred in the dependents, but not defined.");
            undefinedConfigValue.visible(false);
            configValuesByFieldName.put((String)missingDepedent, undefinedConfigValue);
        });
        fields.forEachTopLevelField(field -> field.validate(this, fields::fieldWithName, configValuesByFieldName));
        return configValuesByFieldName;
    }

    default public void forEachMatchingFieldName(String regex, BiConsumer<String, String> function) {
        this.forEachMatchingFieldName(Pattern.compile(regex), function);
    }

    default public void forEachMatchingFieldName(Pattern regex, BiConsumer<String, String> function) {
        this.asMap().forEach((? super K fieldName, ? super V fieldValue) -> {
            if (regex.matcher((CharSequence)fieldName).matches()) {
                function.accept((String)fieldName, (String)fieldValue);
            }
        });
    }

    default public <T> void forEachMatchingFieldNameWithInteger(String regex, BiConsumer<String, Integer> function) {
        this.forEachMatchingFieldNameWithInteger(Pattern.compile(regex), 1, function);
    }

    default public <T> void forEachMatchingFieldNameWithInteger(String regex, int groupNumber, BiConsumer<String, Integer> function) {
        this.forEachMatchingFieldNameWithInteger(Pattern.compile(regex), groupNumber, function);
    }

    default public <T> void forEachMatchingFieldNameWithInteger(Pattern regex, int groupNumber, BiConsumer<String, Integer> function) {
        BiFunction<String, String, Integer> extractor = (fieldName, strValue) -> {
            try {
                return Integer.valueOf(strValue);
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unexpected value {} extracted from configuration field '{}' using regex '{}'", strValue, fieldName, regex);
                return null;
            }
        };
        this.forEachMatchingFieldName(regex, groupNumber, extractor, function);
    }

    default public <T> void forEachMatchingFieldNameWithBoolean(String regex, BiConsumer<String, Boolean> function) {
        this.forEachMatchingFieldNameWithBoolean(Pattern.compile(regex), 1, function);
    }

    default public <T> void forEachMatchingFieldNameWithBoolean(String regex, int groupNumber, BiConsumer<String, Boolean> function) {
        this.forEachMatchingFieldNameWithBoolean(Pattern.compile(regex), groupNumber, function);
    }

    default public <T> void forEachMatchingFieldNameWithBoolean(Pattern regex, int groupNumber, BiConsumer<String, Boolean> function) {
        BiFunction<String, String, Boolean> extractor = (fieldName, strValue) -> {
            try {
                return Boolean.parseBoolean(strValue);
            }
            catch (NumberFormatException e) {
                LoggerFactory.getLogger(this.getClass()).error("Unexpected value {} extracted from configuration field '{}' using regex '{}'", strValue, fieldName, regex);
                return null;
            }
        };
        this.forEachMatchingFieldName(regex, groupNumber, extractor, function);
    }

    default public <T> void forEachMatchingFieldNameWithString(String regex, BiConsumer<String, String> function) {
        this.forEachMatchingFieldNameWithString(Pattern.compile(regex), 1, function);
    }

    default public <T> void forEachMatchingFieldNameWithString(String regex, int groupNumber, BiConsumer<String, String> function) {
        this.forEachMatchingFieldNameWithString(Pattern.compile(regex), groupNumber, function);
    }

    default public <T> void forEachMatchingFieldNameWithString(Pattern regex, int groupNumber, BiConsumer<String, String> function) {
        this.forEachMatchingFieldName(regex, groupNumber, (String fieldName, String value) -> value, function);
    }

    default public <T> void forEachMatchingFieldName(String regex, int groupNumber, BiFunction<String, String, T> groupExtractor, BiConsumer<String, T> function) {
        this.forEachMatchingFieldName(Pattern.compile(regex), groupNumber, groupExtractor, function);
    }

    default public <T> void forEachMatchingFieldName(Pattern regex, int groupNumber, BiFunction<String, String, T> groupExtractor, BiConsumer<String, T> function) {
        this.asMap().forEach((? super K fieldName, ? super V fieldValue) -> {
            String groupValue;
            Object extractedValue;
            Matcher matcher = regex.matcher((CharSequence)fieldName);
            if (matcher.matches() && (extractedValue = groupExtractor.apply((String)fieldName, groupValue = matcher.group(groupNumber))) != null) {
                function.accept((String)fieldValue, (Object)extractedValue);
            }
        });
    }

    default public <T> void forEach(BiConsumer<String, String> function) {
        this.asMap().forEach(function);
    }

    default public String getFallbackStringProperty(Field newProperty, Field oldProperty) {
        return this.getString(newProperty, () -> this.getString(oldProperty));
    }

    default public String getFallbackStringPropertyWithWarning(Field newProperty, Field oldProperty) {
        if (this.hasKey(oldProperty.name()) && this.hasKey(newProperty.name())) {
            CONFIGURATION_LOGGER.warn("Provided configuration has deprecated property \"" + oldProperty.name() + "\" and new property \"" + newProperty.name() + "\" set. Using value from \"" + newProperty.name() + "\"!");
        }
        return this.getString(newProperty, () -> {
            String oldValue = this.getString(oldProperty);
            if (oldValue != null && !oldValue.equals(oldProperty.defaultValueAsString())) {
                CONFIGURATION_LOGGER.warn("Using configuration property \"" + oldProperty.name() + "\" is deprecated and will be removed in future versions. Please use \"" + newProperty.name() + "\" instead.");
            }
            return oldValue;
        });
    }

    public static class Builder
    implements ConfigBuilder<Configuration, Builder> {
        private final Properties props = new Properties();

        protected Builder() {
        }

        protected Builder(Properties props) {
            this.props.putAll((Map<?, ?>)props);
        }

        @Override
        public Builder with(String key, String value) {
            this.props.setProperty(key, value);
            return this;
        }

        @Override
        public Builder withDefault(String key, String value) {
            if (!this.props.containsKey(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        @Override
        public Builder apply(Consumer<Builder> function) {
            function.accept(this);
            return this;
        }

        @Override
        public Builder changeString(String key, Function<String, String> function) {
            return this.changeString(key, null, function);
        }

        @Override
        public Builder changeString(Field field, Function<String, String> function) {
            return this.changeString(field.name(), field.defaultValueAsString(), function);
        }

        protected Builder changeString(String key, String defaultValue, Function<String, String> function) {
            String existing = this.props.getProperty(key);
            if (existing == null) {
                existing = defaultValue;
            }
            String newValue = function.apply(existing);
            return this.with(key, newValue);
        }

        @Override
        public Configuration build() {
            return Configuration.from(this.props);
        }
    }

    public static interface ConfigBuilder<C extends Configuration, B extends ConfigBuilder<C, B>> {
        public B with(String var1, String var2);

        default public B with(String key, Object value) {
            return this.with(key, value != null ? value.toString() : null);
        }

        default public B with(String key, EnumeratedValue value) {
            return this.with(key, value != null ? value.getValue() : null);
        }

        default public B with(String key, int value) {
            return this.with(key, Integer.toString(value));
        }

        default public B with(String key, float value) {
            return this.with(key, Float.toString(value));
        }

        default public B with(String key, double value) {
            return this.with(key, Double.toString(value));
        }

        default public B with(String key, long value) {
            return this.with(key, Long.toString(value));
        }

        default public B with(String key, boolean value) {
            return this.with(key, Boolean.toString(value));
        }

        default public B with(String key, Class<?> value) {
            return this.with(key, value != null ? value.getName() : null);
        }

        public B withDefault(String var1, String var2);

        default public B withDefault(String key, Object value) {
            return this.withDefault(key, value != null ? value.toString() : null);
        }

        default public B withDefault(String key, EnumeratedValue value) {
            return this.withDefault(key, value != null ? value.getValue() : null);
        }

        default public B withDefault(String key, int value) {
            return this.withDefault(key, Integer.toString(value));
        }

        default public B withDefault(String key, float value) {
            return this.withDefault(key, Float.toString(value));
        }

        default public B withDefault(String key, double value) {
            return this.withDefault(key, Double.toString(value));
        }

        default public B withDefault(String key, long value) {
            return this.withDefault(key, Long.toString(value));
        }

        default public B withDefault(String key, boolean value) {
            return this.withDefault(key, Boolean.toString(value));
        }

        default public B withDefault(String key, Class<?> value) {
            return this.withDefault(key, value != null ? value.getName() : null);
        }

        default public B withDefault(Configuration other) {
            return (B)this.apply(builder -> other.forEach(builder::withDefault));
        }

        default public B with(Configuration other) {
            return (B)this.apply(builder -> other.forEach(builder::with));
        }

        default public B with(Field field, String value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, Object value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, EnumeratedValue value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, int value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, float value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, double value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, long value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, boolean value) {
            return this.with(field.name(), value);
        }

        default public B with(Field field, Class<?> value) {
            return this.with(field.name(), value);
        }

        default public B withDefault(Field field, String value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, Object value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, int value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, float value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, double value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, long value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, boolean value) {
            return this.withDefault(field.name(), value);
        }

        default public B withDefault(Field field, Class<?> value) {
            return this.withDefault(field.name(), value != null ? value.getName() : null);
        }

        public B apply(Consumer<B> var1);

        default public B changeBoolean(String key, Function<Boolean, Boolean> function) {
            Function<String, String> strFunction = existingStr -> {
                Boolean result = (Boolean)function.apply(existingStr != null ? Boolean.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(key, strFunction);
        }

        public B changeString(String var1, Function<String, String> var2);

        default public B changeDouble(String key, Function<Double, Double> function) {
            Function<String, String> strFunction = existingStr -> {
                Double result = (Double)function.apply(existingStr != null ? Double.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(key, strFunction);
        }

        default public B changeFloat(String key, Function<Float, Float> function) {
            Function<String, String> strFunction = existingStr -> {
                Float result = (Float)function.apply(existingStr != null ? Float.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(key, strFunction);
        }

        default public B changeLong(String key, Function<Long, Long> function) {
            Function<String, String> strFunction = existingStr -> {
                Long result = (Long)function.apply(existingStr != null ? Long.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(key, strFunction);
        }

        default public B changeInteger(String key, Function<Integer, Integer> function) {
            Function<String, String> strFunction = existingStr -> {
                Integer result = (Integer)function.apply(existingStr != null ? Integer.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(key, strFunction);
        }

        default public B changeBoolean(Field field, Function<Boolean, Boolean> function) {
            Function<String, String> strFunction = existingStr -> {
                Boolean result = (Boolean)function.apply(existingStr != null ? Boolean.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(field, strFunction);
        }

        public B changeString(Field var1, Function<String, String> var2);

        default public B changeDouble(Field field, Function<Double, Double> function) {
            Function<String, String> strFunction = existingStr -> {
                Double result = (Double)function.apply(existingStr != null ? Double.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(field, strFunction);
        }

        default public B changeFloat(Field field, Function<Float, Float> function) {
            Function<String, String> strFunction = existingStr -> {
                Float result = (Float)function.apply(existingStr != null ? Float.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(field, strFunction);
        }

        default public B changeLong(Field field, Function<Long, Long> function) {
            Function<String, String> strFunction = existingStr -> {
                Long result = (Long)function.apply(existingStr != null ? Long.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(field, strFunction);
        }

        default public B changeInteger(Field field, Function<Integer, Integer> function) {
            Function<String, String> strFunction = existingStr -> {
                Integer result = (Integer)function.apply(existingStr != null ? Integer.valueOf(existingStr) : null);
                return result != null ? result.toString() : null;
            };
            return this.changeString(field, strFunction);
        }

        public C build();
    }
}

