/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.gson.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import io.jsonwebtoken.gson.io.GsonSupplierSerializer;
import io.jsonwebtoken.io.AbstractSerializer;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Supplier;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class GsonSerializer<T>
extends AbstractSerializer<T> {
    static final Gson DEFAULT_GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setNumberToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).registerTypeHierarchyAdapter(Supplier.class, (Object)GsonSupplierSerializer.INSTANCE).disableHtmlEscaping().create();
    protected final Gson gson;

    public GsonSerializer() {
        this(DEFAULT_GSON);
    }

    public GsonSerializer(Gson gson) {
        Assert.notNull((Object)gson, (String)"gson cannot be null.");
        this.gson = gson;
        String json = this.gson.toJson((Object)TestSupplier.INSTANCE);
        if (json.contains("value")) {
            String msg = "Invalid Gson instance - it has not been registered with the necessary " + Supplier.class.getName() + " type adapter.  When using the GsonBuilder, ensure this " + "type adapter is registered by calling gsonBuilder.registerTypeHierarchyAdapter(" + Supplier.class.getName() + ".class, " + GsonSupplierSerializer.class.getName() + ".INSTANCE) before calling gsonBuilder.create()";
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSerialize(T t, OutputStream out) {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        try {
            Object o = t;
            if (o instanceof byte[]) {
                o = Encoders.BASE64.encode((Object)((byte[])o));
            } else if (o instanceof char[]) {
                o = new String((char[])o);
            }
            this.writeValue(o, writer);
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose((Closeable[])new Closeable[]{writer});
            throw throwable;
        }
        Objects.nullSafeClose((Closeable[])new Closeable[]{writer});
    }

    protected void writeValue(Object o, Writer writer) {
        this.gson.toJson(o, (Appendable)writer);
    }

    private static class TestSupplier<T>
    implements Supplier<T> {
        private static final TestSupplier<String> INSTANCE = new TestSupplier<String>("test");
        private final T value;

        private TestSupplier(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }
    }
}

