/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.springboot.starter;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface CRDApplier {
    public static final CRDApplier NOOP = () -> LoggerFactory.getLogger(CRDApplier.class).debug("Not searching for CRDs to apply");

    public void apply();

    public static class DefaultCRDApplier
    implements CRDApplier {
        private static final Logger log = LoggerFactory.getLogger(DefaultCRDApplier.class);
        private static final int CRD_READY_WAIT = 2000;
        private final CRDTransformer crdTransformer;
        private final KubernetesClient kubernetesClient;
        private final String crdSuffix;
        private final String crdPath;

        public DefaultCRDApplier(KubernetesClient kubernetesClient, List<CRDTransformer> transformers, String crdPath, String crdSuffix) {
            this.crdTransformer = CRDTransformer.reduce(transformers);
            this.kubernetesClient = kubernetesClient;
            this.crdSuffix = crdSuffix;
            this.crdPath = crdPath;
        }

        @Override
        public void apply() {
            log.debug("Uploading CRDs with suffix {} under {}", (Object)this.crdSuffix, (Object)this.crdPath);
            Arrays.stream(this.findFiles()).forEach(this::applyCrd);
        }

        private File[] findFiles() {
            URL resource = Objects.requireNonNull(this.getClass().getResource(this.crdPath), "Could not find the configured CRD path");
            try {
                return new File(resource.toURI()).listFiles((ignored, name) -> name.endsWith(this.crdSuffix));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private void applyCrd(File crdFile) {
            try (FileInputStream is = new FileInputStream(crdFile);){
                List<HasMetadata> crds = this.kubernetesClient.load((InputStream)is).items().stream().map(this.crdTransformer).toList();
                this.kubernetesClient.resourceList(crds).createOrReplace();
                Thread.sleep(2000L);
                this.logUploaded(crds);
            }
            catch (IOException | InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        }

        private void logUploaded(List<HasMetadata> crds) {
            String crdNames = crds.stream().map(HasMetadata::getMetadata).map(ObjectMeta::getName).collect(Collectors.joining(", "));
            log.info("Uploaded CRDs: {}", (Object)crdNames);
        }
    }

    public static interface CRDTransformer
    extends UnaryOperator<HasMetadata> {
        default public CRDTransformer thenTransform(@NotNull CRDTransformer after) {
            return t -> (HasMetadata)after.apply((HasMetadata)this.apply(t));
        }

        public static CRDTransformer reduce(List<CRDTransformer> transformers) {
            return transformers.stream().reduce(t -> t, CRDTransformer::thenTransform);
        }
    }
}

