/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.hetu.core.transport.execution.buffer.PagesSerde;
import io.hetu.core.transport.execution.buffer.PagesSerdeFactory;
import io.hetu.core.transport.execution.buffer.SerializedPage;
import io.prestosql.client.ClientSelectedRole;
import io.prestosql.client.Column;
import io.prestosql.client.CrossRegionDynamicFilterResponse;
import io.prestosql.client.DataCenterClientSession;
import io.prestosql.client.DataCenterQueryResults;
import io.prestosql.client.DataCenterResponse;
import io.prestosql.client.DataCenterResponseType;
import io.prestosql.client.DataCenterStatementClient;
import io.prestosql.client.JsonResponse;
import io.prestosql.client.QueryData;
import io.prestosql.client.QueryStatusInfo;
import io.prestosql.client.StatementStats;
import io.prestosql.client.Warning;
import io.prestosql.client.block.ExternalBlockEncodingSerde;
import io.prestosql.client.protocol.DataCenterRowIterable;
import io.prestosql.client.util.HttpUtil;
import io.prestosql.spi.Page;
import io.prestosql.spi.block.BlockEncodingSerde;
import io.prestosql.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class DataCenterHTTPClientV1
implements DataCenterStatementClient {
    private static final Logger log = Logger.get(DataCenterHTTPClientV1.class);
    private static final String ROOT_URL = "/v1/dc/statement/";
    private static final JsonCodec<DataCenterResponse> DATA_CENTER_RESPONSE_JSON_CODEC = JsonCodec.jsonCodec(DataCenterResponse.class);
    private static final JsonCodec<DataCenterQueryResults> DATA_CENTER_QUERY_RESULTS_JSON_CODEC = JsonCodec.jsonCodec(DataCenterQueryResults.class);
    private static final JsonCodec<CrossRegionDynamicFilterResponse> CRDF_RESPONSE_JSON_CODEC = JsonCodec.jsonCodec(CrossRegionDynamicFilterResponse.class);
    private static final Splitter SESSION_HEADER_SPLITTER = Splitter.on((char)'=').limit(2).trimResults();
    private final OkHttpClient httpClient;
    private final String query;
    private final AtomicReference<DataCenterQueryResults> currentResults = new AtomicReference();
    private final AtomicReference<String> setCatalog = new AtomicReference();
    private final AtomicReference<String> setSchema = new AtomicReference();
    private final AtomicReference<String> setPath = new AtomicReference();
    private final Map<String, String> setSessionProperties = new ConcurrentHashMap<String, String>();
    private final Set<String> resetSessionProperties = Sets.newConcurrentHashSet();
    private final Map<String, ClientSelectedRole> setRoles = new ConcurrentHashMap<String, ClientSelectedRole>();
    private final Map<String, String> addedPreparedStatements = new ConcurrentHashMap<String, String>();
    private final Set<String> deallocatedPreparedStatements = Sets.newConcurrentHashSet();
    private final AtomicReference<String> startedTransactionId = new AtomicReference();
    private final AtomicBoolean clearTransactionId = new AtomicBoolean();
    private final ZoneId timeZone;
    private final Duration requestTimeoutNanos;
    private final String slug;
    private final String queryId;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private final HttpUrl serverURI;
    private final HttpUrl cancelUrl;
    private final String clientId;
    private long token;
    private final PagesSerde serde;
    private final DataCenterClientSession session;
    private TypeManager typeManager;

    public DataCenterHTTPClientV1(OkHttpClient httpClient, DataCenterClientSession session, String query, String queryId) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.timeZone = session.getTimeZone();
        this.requestTimeoutNanos = session.getClientRequestTimeout();
        this.clientId = UUID.randomUUID().toString();
        this.serverURI = HttpUrl.get((URI)session.getServer());
        if (this.serverURI == null) {
            throw new RuntimeException("Invalid server Url:" + session.getServer());
        }
        this.typeManager = session.getTypeManager();
        this.serde = new PagesSerdeFactory((BlockEncodingSerde)new ExternalBlockEncodingSerde(this.typeManager), true).createPagesSerde();
        DataCenterResponse result = null;
        for (int attempts = 0; attempts <= 10; ++attempts) {
            Request request = HttpUtil.buildQueryRequest(this.clientId, session, queryId, query);
            try {
                JsonResponse<DataCenterResponse> response;
                if (attempts > 0) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(attempts * 10);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Could not establish the connection");
                    }
                }
                if ((response = JsonResponse.execute(DATA_CENTER_RESPONSE_JSON_CODEC, httpClient, request)).getStatusCode() != 200 || !response.hasValue()) {
                    this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                    throw this.requestFailedException("starting query", request, response);
                }
                result = response.getValue();
                break;
            }
            catch (UncheckedIOException ex) {
                log.debug("Failed submitting query. Retrying...", new Object[]{ex});
                continue;
            }
        }
        if (result == null) {
            throw new RuntimeException("received null response from data center");
        }
        if (result.getState() == DataCenterResponse.State.FINISHED_ALREADY) {
            this.slug = null;
            this.cancelUrl = null;
            this.state.compareAndSet(State.RUNNING, State.FINISHED);
        } else {
            if (!result.isRegistered()) {
                this.state.compareAndSet(State.RUNNING, State.FINISHED);
            }
            this.slug = result.getSlug();
            this.cancelUrl = this.serverURI.newBuilder().encodedPath(ROOT_URL + this.queryId + "/" + this.slug).build();
        }
        this.currentResults.set(new DataCenterQueryResults(this.queryId, this.serverURI.uri(), null, this.state.get() == State.RUNNING ? URI.create("") : null, null, null, StatementStats.builder().setState(this.state.toString()).setQueued(true).setElapsedTimeMillis(0L).setQueuedTimeMillis(0L).build(), null, (List<Warning>)ImmutableList.of(), null, true));
    }

    private HttpUrl nextURL() {
        return this.serverURI.newBuilder().encodedPath(ROOT_URL + (Object)((Object)DataCenterResponseType.HTTP_PULL) + "/" + this.clientId + "/" + this.queryId + "/" + this.slug + "/" + this.token).build();
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    public boolean isRunning() {
        return this.state.get() == State.RUNNING;
    }

    @Override
    public boolean isClientAborted() {
        return this.state.get() == State.CLIENT_ABORTED;
    }

    @Override
    public boolean isClientError() {
        return this.state.get() == State.CLIENT_ERROR;
    }

    @Override
    public boolean isFinished() {
        return this.state.get() == State.FINISHED;
    }

    @Override
    public StatementStats getStats() {
        return this.currentResults.get().getStats();
    }

    @Override
    public QueryStatusInfo currentStatusInfo() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"current position is not valid (cursor past end)");
        return this.currentResults.get();
    }

    @Override
    public List<Page> getPages() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"current position is not valid (cursor past end)");
        ArrayList<Page> pages = new ArrayList<Page>();
        List<SerializedPage> dcSerializedPages = this.currentResults.get().getData();
        if (dcSerializedPages == null) {
            return pages;
        }
        for (SerializedPage dcSerializedPage : dcSerializedPages) {
            pages.add(this.serde.deserialize(dcSerializedPage));
        }
        return pages;
    }

    @Override
    public QueryData currentData() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"current position is not valid (cursor past end)");
        return new RowQueryData(this.getPages(), this.currentResults.get().getColumns(), this.typeManager);
    }

    @Override
    public QueryStatusInfo finalStatusInfo() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0, (Object)"current position is still valid");
        return this.currentResults.get();
    }

    @Override
    public Optional<String> getSetCatalog() {
        return Optional.ofNullable(this.setCatalog.get());
    }

    @Override
    public Optional<String> getSetSchema() {
        return Optional.ofNullable(this.setSchema.get());
    }

    @Override
    public Optional<String> getSetPath() {
        return Optional.ofNullable(this.setPath.get());
    }

    @Override
    public Map<String, String> getSetSessionProperties() {
        return ImmutableMap.copyOf(this.setSessionProperties);
    }

    @Override
    public Set<String> getResetSessionProperties() {
        return ImmutableSet.copyOf(this.resetSessionProperties);
    }

    @Override
    public Map<String, ClientSelectedRole> getSetRoles() {
        return ImmutableMap.copyOf(this.setRoles);
    }

    @Override
    public Map<String, String> getAddedPreparedStatements() {
        return ImmutableMap.copyOf(this.addedPreparedStatements);
    }

    @Override
    public Set<String> getDeallocatedPreparedStatements() {
        return ImmutableSet.copyOf(this.deallocatedPreparedStatements);
    }

    @Override
    @Nullable
    public String getStartedTransactionId() {
        return this.startedTransactionId.get();
    }

    @Override
    public boolean isClearTransactionId() {
        return this.clearTransactionId.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean advance() {
        JsonResponse<DataCenterQueryResults> response;
        if (!this.isRunning()) {
            return false;
        }
        QueryStatusInfo queryStatusInfo = this.currentStatusInfo();
        if (queryStatusInfo.getNextUri() == null) {
            if (queryStatusInfo.getStats().getState().equals("FAILED")) {
                this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                log.error("fetching next result failed.");
                throw new RuntimeException("fetching next result failed.");
            }
            this.state.compareAndSet(State.RUNNING, State.FINISHED);
            return false;
        }
        Request request = HttpUtil.prepareRequest(this.nextURL(), this.session).build();
        RuntimeException cause = null;
        long start = System.nanoTime();
        long attempts = 0L;
        while (true) {
            if (this.isClientAborted()) {
                return false;
            }
            Duration sinceStart = Duration.nanosSince((long)start);
            if (attempts > 0L && sinceStart.compareTo(this.requestTimeoutNanos) > 0) {
                this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                throw new RuntimeException(String.format("Error fetching next (attempts: %s, duration: %s)", attempts, sinceStart), cause);
            }
            if (attempts > 0L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(attempts * 100L);
                }
                catch (InterruptedException e) {
                    try {
                        this.close();
                    }
                    finally {
                        Thread.currentThread().interrupt();
                    }
                    this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
                    throw new RuntimeException("StatementClient thread was interrupted");
                }
            }
            ++attempts;
            try {
                response = JsonResponse.execute(DATA_CENTER_QUERY_RESULTS_JSON_CODEC, this.httpClient, request);
            }
            catch (RuntimeException e) {
                cause = e;
                continue;
            }
            if (response.getStatusCode() == 200 && response.hasValue()) {
                this.processResponse(response.getHeaders(), response.getValue());
                return true;
            }
            if (response.getStatusCode() != 503) break;
        }
        this.state.compareAndSet(State.RUNNING, State.CLIENT_ERROR);
        log.error("response.getStatusCode=%s", new Object[]{response.getStatusCode()});
        if (response.getException() != null) {
            throw new RuntimeException("fetching next result: " + response.toString(), response.getException());
        }
        throw new RuntimeException("fetching next result: " + response.toString());
    }

    private void processResponse(Headers headers, DataCenterQueryResults results) {
        ++this.token;
        if (results.getUseHeaderInformation()) {
            List keyValue;
            this.setCatalog.set(headers.get("X-Presto-Set-Catalog"));
            this.setSchema.set(headers.get("X-Presto-Set-Schema"));
            this.setPath.set(headers.get("X-Presto-Set-Path"));
            for (String setSession : headers.values("X-Presto-Set-Session")) {
                keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)setSession);
                if (keyValue.size() != 2) continue;
                this.setSessionProperties.put((String)keyValue.get(0), DataCenterHTTPClientV1.urlDecode((String)keyValue.get(1)));
            }
            this.resetSessionProperties.addAll(headers.values("X-Presto-Clear-Session"));
            for (String setRole : headers.values("X-Presto-Set-Role")) {
                keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)setRole);
                if (keyValue.size() != 2) continue;
                this.setRoles.put((String)keyValue.get(0), ClientSelectedRole.valueOf(DataCenterHTTPClientV1.urlDecode((String)keyValue.get(1))));
            }
            for (String entry : headers.values("X-Presto-Added-Prepare")) {
                keyValue = SESSION_HEADER_SPLITTER.splitToList((CharSequence)entry);
                if (keyValue.size() != 2) continue;
                this.addedPreparedStatements.put(DataCenterHTTPClientV1.urlDecode((String)keyValue.get(0)), DataCenterHTTPClientV1.urlDecode((String)keyValue.get(1)));
            }
            for (String entry : headers.values("X-Presto-Deallocated-Prepare")) {
                this.deallocatedPreparedStatements.add(DataCenterHTTPClientV1.urlDecode(entry));
            }
            String startedTransactionId = headers.get("X-Presto-Started-Transaction-Id");
            if (startedTransactionId != null) {
                this.startedTransactionId.set(startedTransactionId);
            }
            if (headers.get("X-Presto-Clear-Transaction-Id") != null) {
                this.clearTransactionId.set(true);
            }
        }
        this.currentResults.set(results);
    }

    @Override
    public void cancelLeafStage() {
        Preconditions.checkState((!this.isClientAborted() ? 1 : 0) != 0, (Object)"client is closed");
        URI uri = this.currentStatusInfo().getPartialCancelUri();
        if (uri != null) {
            this.httpDelete(uri);
        }
    }

    @Override
    public boolean isTimeInMilliseconds() {
        return false;
    }

    @Override
    public boolean applyDynamicFilters(Map<String, byte[]> dynamicFilters) {
        Request request = HttpUtil.buildDynamicFilterRequest(this.clientId, this.session, this.queryId, dynamicFilters);
        JsonResponse<CrossRegionDynamicFilterResponse> response = JsonResponse.execute(CRDF_RESPONSE_JSON_CODEC, this.httpClient, request);
        return response.getStatusCode() == 200 && response.hasValue() && response.getValue().getApplied() != false;
    }

    @Override
    public void close() {
        URI uri;
        if (this.state.compareAndSet(State.RUNNING, State.CLIENT_ABORTED) && (uri = this.cancelUrl.uri()) != null) {
            this.httpDelete(uri);
        }
    }

    private void httpDelete(URI uri) {
        HttpUrl httpUrl = HttpUrl.get((URI)uri);
        if (httpUrl == null) {
            throw new RuntimeException("Invalid URL:" + uri.toString());
        }
        Request request = HttpUtil.prepareRequest(httpUrl, this.session).delete().build();
        try {
            this.httpClient.newCall(request).execute().close();
        }
        catch (IOException e) {
            log.debug("Failed to execute delete request: " + request, new Object[]{e});
        }
    }

    private static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static enum State {
        RUNNING,
        CLIENT_ERROR,
        CLIENT_ABORTED,
        FINISHED;

    }

    private static class RowQueryData
    implements QueryData {
        private Iterable<List<Object>> data;

        private RowQueryData(List<Page> pages, List<Column> columns, TypeManager typeManager) {
            if (pages != null && columns != null) {
                ImmutableList.Builder rows = ImmutableList.builder();
                long rowsCount = 0L;
                for (Page page : pages) {
                    rowsCount += (long)page.getPositionCount();
                    rows.add((Object)new DataCenterRowIterable(null, columns, page, typeManager));
                }
                if (rowsCount > 0L) {
                    this.data = Iterables.concat((Iterable)rows.build());
                }
            }
        }

        @Override
        public Iterable<List<Object>> getData() {
            return this.data;
        }
    }
}

